c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it

c     FILENAME: S_SELF.FOR
c     Last revised: 15: 02:1993 (PCh)
c     gauge boson contributions adjusted to the DIMENSIONAL
c     REDUCTION regularization

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains expressions for scalar self-energy functions  c
c     and its renormalization.                                         c
c     See: Chankowski,Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437       c
c     available as hep-ph-9303309:                                     c
c                                                                      c
c     The definition of the self energy as follows:                    c
c              ______                                                  c
c        k    |      |   k                                             c
c       ------|      |-----             = - i s_sig(k^2,i,j)           c
c       S_i   |______|  S_j                                            c
c                                   (or = - i s_ren(k^2,i,j)           c
c                           for the renormalized self energy)          c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function s_3sig1(s,i,j)
c     Z + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_3sig1 = 0
      do 10 k=1,2
10      s_3sig1 = s_3sig1 + e2*am(i,k)*am(j,k)/2/sct2
     1          * (a(zm) - a(pm(k))/2 - (s + pm(k)*pm(k) - zm2/2)
     2          * b0(s,pm(k),zm))
      return
      end

      complex*16 function s_3sig2(s,i,j)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_3sig2 = 0
      do 10 k=1,2
10      s_3sig2 = s_3sig2 + e2*am(i,k)*am(j,k)/st2
     1          * (a(wm) - a(cm(k))/2 - (s + cm(k)*cm(k) - wm2/2)
     2          * b0(s,cm(k),wm))
      return
      end

      complex*16 function s_3sig36(s,i,j)
c     WW and 2 W-ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      s_3sig36 = e2*e2/st2/st2/8*cr(i)*cr(j)*7*b0(s,wm,wm)
     1         - idflag*e2*e2/st2/st2/2.d0*cr(i)*cr(j)
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      complex*16 function s_3sig45(s,i,j)
c     ZZ and 2 Z-ghost in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/dimreg/idflag
      s_3sig45 = e2*e2/sct2/sct2/16*cr(i)*cr(j)*7*b0(s,zm,zm)
     1         - idflag*e2*e2/sct2/sct2/4.d0*cr(i)*cr(j)
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      complex*16 function s_3sig7(s,i,j)
c     Fermion pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      s_3sig7 = 0
      do 10 k=1,3
        s_3sig7 = s_3sig7 + 2*em(k)*em(k)/v1/v1*zr(1,i)*zr(1,j)
     1          * (2*a(em(k)) - (4*em(k)*em(k) - s)*b0(s,em(k),em(k)))
        s_3sig7 = s_3sig7 + 6*um(k)*um(k)/v2/v2*zr(2,i)*zr(2,j)
     1          * (2*a(um(k)) - (4*um(k)*um(k) - s)*b0(s,um(k),um(k)))
10      s_3sig7 = s_3sig7 + 6*dm(k)*dm(k)/v1/v1*zr(1,i)*zr(1,j)
     1          * (2*a(dm(k)) - (4*dm(k)*dm(k) - s)*b0(s,dm(k),dm(k)))
      return
      end

      complex*16 function s_3sig8(s,i,j)
c     2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_3sig8 = 0
      do 10 k=1,2
        do 10 l=1,2
10        s_3sig8 = s_3sig8 + ah(k,l)**2*b0(s,pm(k),pm(l))
      s_3sig8 = s_3sig8*e2*e2*br(i)*br(j)/32/sct2/sct2
      return
      end

      complex*16 function s_3sig9(s,i,j)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_3sig9 = 0
      do 10 k=1,2
        do 10 l=1,2
10        s_3sig9 = s_3sig9
     1            + e2*v_hhs(i,k,l)*v_hhs(j,l,k)/4/st2*b0(s,cm(k),cm(l))
      return
      end

      complex*16 function s_3sig10(s,i,j)
c     2 scalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_3sig10 = 0
      do 10 k=1,2
        do 10 l=1,2
10        s_3sig10 = s_3sig10
     1             + v_sss(i,k,l)*v_sss(j,l,k)*b0(s,rm(k),rm(l))
      s_3sig10 = s_3sig10*e2*e2/32/sct2/sct2
      return
      end

      complex*16 function s_3sig11(s,i,j)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      s_3sig11 = 0
c     Sneutrino contribution
      do 10 k=1,3
10      s_3sig11 = s_3sig11 + b0(s,vm(k),vm(k))
      s_3sig11 = s_3sig11*e2*e2/16/sct2/sct2*br(i)*br(j)
c     Other sfermions
      do 20 k=1,6
        do 20 l=1,6
          s_3sig11 = s_3sig11 + v_lls(k,l,i)*v_lls(l,k,j)
     1             * b0(s,slm(k),slm(l))
          s_3sig11 = s_3sig11 + 3*v_uus(k,l,i)*v_uus(l,k,j)
     1             * b0(s,sum(k),sum(l))
20        s_3sig11 = s_3sig11 + 3*v_dds(k,l,i)*v_dds(l,k,j)
     1             * b0(s,sdm(k),sdm(l))
      return
      end

      complex*16 function s_3sig12(s,i,j)
c     Neutralino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zn,v_nns
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      s_3sig12 = 0
      do 10 k=1,4
        do 10 l=1,4
          a1 = v_nns(k,l,i)*conjg(v_nns(k,l,j))
     1       + conjg(v_nns(l,k,i))*v_nns(l,k,j)
          a2 = v_nns(k,l,i)*v_nns(l,k,j)
     1       + conjg(v_nns(l,k,i)*v_nns(k,l,j))
10        s_3sig12 = s_3sig12 + e2/sct2/8
     1             * (a1*(a(fnm(l)) + a(fnm(k)) + (s - fnm(k)*fnm(k)
     2             - fnm(l)*fnm(l))*b0(s,fnm(k),fnm(l)))
     3             - 2*a2*fnm(k)*fnm(l)*b0(s,fnm(k),fnm(l)))
      return
      end

      complex*16 function s_3sig13(s,i,j)
c     Chargino pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 zpos,zneg,v_ccs
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      s_3sig13 = 0
      do 10 k=1,2
        do 10 l=1,2
          a1 = v_ccs(k,l,i)*conjg(v_ccs(k,l,j))
     1       + conjg(v_ccs(l,k,i))*v_ccs(l,k,j)
          a2 = v_ccs(k,l,i)*v_ccs(l,k,j)
     1       + conjg(v_ccs(l,k,i)*v_ccs(k,l,j))
10        s_3sig13 = s_3sig13 + e2/2/st2
     1             *(a1*(a(fcm(l)) + a(fcm(k)) + (s - fcm(k)*fcm(k)
     2             - fcm(l)*fcm(l))*b0(s,fcm(k),fcm(l)))
     3             - 2*a2*fcm(k)*fcm(l)*b0(s,fcm(k),fcm(l)))
      return
      end

      double precision function s_4sig1(i,j)
c     W in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/delta/d(6,6)
      common/dimreg/idflag
      s_4sig1 = - e2/st2*d(i,j)*2*a(wm)
     1        - idflag*e2/st2*d(i,j)*wm2
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      double precision function s_4sig2(i,j)
c     Z in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/delta/d(6,6)
      common/dimreg/idflag
      s_4sig2 = - e2/sct2*d(i,j)*a(zm)
     1        - idflag*e2/sct2*d(i,j)*zm2/2.d0
c     the last term (in the continuation line) vanishes in DRED
      return
      end

      double precision function s_4sig3(i,j)
c     Scalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_4sig3 = 0
      do 10 k=1,2
10      s_4sig3 = s_4sig3 - e2/8/sct2*v_ssss(i,j,k,k)*a(rm(k))
      return
      end

      double precision function s_4sig4(i,j)
c     Pseudoscalar in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_4sig4 = 0
      do 10 k=1,2
10      s_4sig4 = s_4sig4 - e2/8/sct2*ar(i,j)*ah(k,k)*a(pm(k))
      return
      end

      double precision function s_4sig5(i,j)
c     Charged Higgs in loop
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_4sig5 = 0
      do 10 k=1,2
10      s_4sig5 = s_4sig5 - e2/4/st2*v_hhss(i,j,k,k)*a(cm(k))
      return
      end

      double precision function s_4sig6(i,j)
c     Sfermion in loop
      implicit double precision (a-h,o-z)
      complex*16 v_llss,v_uuss,v_ddss
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s_4sig6 = 0
c     Sneutrino contribution
      do 10 k=1,3
10      s_4sig6 = s_4sig6 - e2/4/sct2*ar(i,j)*a(vm(k))
c     Other sfermions
      do 20 k=1,6
        s_4sig6 = s_4sig6 + dble(v_llss(i,j,k,k))*a(slm(k))
        s_4sig6 = s_4sig6 + 3*dble(v_uuss(i,j,k,k))*a(sum(k))
20      s_4sig6 = s_4sig6 + 3*dble(v_ddss(i,j,k,k))*a(sdm(k))
      return
      end

      complex*16 function s_sig(s,i,j)
c     Full bare scalar self-energy function
      implicit double precision (a-h,o-z)
      complex*16 s_3sig1,s_3sig2,s_3sig36,s_3sig45,s_3sig7,s_3sig8,
     1           s_3sig9,s_3sig10,s_3sig11,s_3sig12,s_3sig13
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/parcont/if,is,ig,ic,in,iq,il
      s_sig = 0
      if (if.eq.1) s_sig = s_sig + s_3sig7(s,i,j)
      if (is.eq.1) s_sig = s_sig + s_3sig11(s,i,j) + s_4sig6(i,j)
      if (ig.eq.1) s_sig = s_sig + s_3sig1(s,i,j)  + s_3sig2(s,i,j)
     1         + s_3sig36(s,i,j) + s_3sig45(s,i,j) + s_3sig8(s,i,j)
     2         + s_3sig9(s,i,j)  + s_3sig10(s,i,j) + s_4sig1(i,j)
     3         + s_4sig2(i,j)    + s_4sig3(i,j)   + s_4sig4(i,j)
     4         + s_4sig5(i,j)
      if (ic.eq.1) s_sig = s_sig + s_3sig13(s,i,j)
      if (in.eq.1) s_sig = s_sig + s_3sig12(s,i,j)
      s_sig = - s_sig/16/pi/pi
      return
      end

      complex*16 function s_ren(s,i,j)
c     Full renormalized scalar self-energy function
      implicit double precision (a-h,o-z)
      complex*16 h
      complex*16 s_sig
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
c     dhs = dm3 !
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hangle/ca,sa,cb,sb
      common/vev/v1,v2
      common/hpar/hm1,hm2,hs,h
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sm1 = hm1 + abs(h*h)
      sm2 = hm2 + abs(h*h)
      if (i*j.eq.1) then
        s_ren = s_sig(s,1,1) - s*(ca*ca*dzh1 + sa*sa*dzh2)
     1        + ca*ca*((sm1*dv1 + hs*dv2 - v2*dhs - tt1)/v1
     2        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v1*v1)
     3        + ca*ca*e2/sct2/8*(4*v1*v1*dzh1 - 3*v1*dv1 - v2*dv2)
     4        + sa*sa*((sm2*dv2 + hs*dv1 - v1*dhs - tt2)/v2
     5        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v2*v2)
     6        + sa*sa*e2/sct2/8*(4*v2*v2*dzh2 - 3*v2*dv2 - v1*dv1)
     7        + 2*sa*ca*(dhs - e2/4*((2*dz2 - 3*dza)/st2
     8        - dzb/ct2)*v1*v2 - e2/sct2/4*(v1*v2*(dzh1 + dzh2)
     9        - v2*dv1 - v1*dv2))
      else if (i*j.eq.2) then
        s_ren = s_sig(s,1,2) - s*sa*ca*(dzh2 - dzh1)
     1        - sa*ca*((sm1*dv1 + hs*dv2 - v2*dhs - tt1)/v1
     2        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v1*v1)
     3        - sa*ca*e2/sct2/8*(4*v1*v1*dzh1 - 3*v1*dv1 - v2*dv2)
     4        + sa*ca*((sm2*dv2 + hs*dv1 - v1*dhs - tt2)/v2
     5        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v2*v2)
     6        + sa*ca*e2/sct2/8*(4*v2*v2*dzh2 - 3*v2*dv2 - v1*dv1)
     7        + (ca*ca - sa*sa)*(dhs - e2*((2*dz2 - 3*dza)/st2
     8        - dzb/ct2)*v1*v2/4 - e2/sct2/4*(v1*v2*(dzh1 + dzh2)
     9        - v2*dv1 - v1*dv2))
      else if (i*j.eq.4) then
        s_ren = s_sig(s,2,2) - s*(ca*ca*dzh2 + sa*sa*dzh1)
     1        + sa*sa*((sm1*dv1 + hs*dv2 - v2*dhs - tt1)/v1
     2        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v1*v1)
     3        + sa*sa*e2/sct2/8*(4*v1*v1*dzh1 - 3*v1*dv1 - v2*dv2)
     4        + ca*ca*((sm2*dv2 + hs*dv1 - v1*dhs - tt2)/v2
     5        + e2/4*((2*dz2 - 3*dza)/st2 - dzb/ct2)*v2*v2)
     6        + ca*ca*e2/sct2/8*(4*v2*v2*dzh2 - 3*v2*dv2 - v1*dv1)
     7        - 2*sa*ca*(dhs - e2/4*((2*dz2 - 3*dza)/st2
     8        - dzb/ct2)*v1*v2 - e2/sct2/4*(v1*v2*(dzh1 + dzh2)
     9        - v2*dv1 - v1*dv2))
      else
        stop 's_ren called with wrong arguments'
      end if
      return
      end




