c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: SSS_VERT.FOR
c     Last revised: 30: 5:1993(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains 3 scalars vertex                             c
c     and its renormalization                                         c
c                                                                     c
c     Incoming scalar S(i):  momentum (p+q)                           c
c     Outgoing scalar S(j):  momentum  q                              c
c     Outgoing scalar S(k):  momentum  p                              c
c                                                                     c
c                                                                     c
c                               _______ S_k                           c
c                             /|                                      c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c       S_i  ___________/      |                                      c
c                       \      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_______  S_j                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 497.                   c
c                                                                     c
c       V = V_tree + i V_1(p,q,pq,i,j,k)                              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

      complex*16 function sss_3vert1(p,q,pq,i,j,k)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c11,c12,c0
c     common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert1 = 0
      do 10 l=1,3
        sss_3vert1 = sss_3vert1 - 8*em(l)*(em(l)/v1)**3
     1             *zr(1,i)*zr(1,j)*zr(1,k)
     2             *((4*em(l)*em(l) + q + pq)*c0(em(l),em(l),em(l))
     3             + 2*(2*q + pq)*c11(em(l),em(l),em(l))
     4             + 2*(p + 2*pq)*c12(em(l),em(l),em(l))
     5             - 3*b0(p,em(l),em(l)))
        call creset
        sss_3vert1 = sss_3vert1 - 24*dm(l)*(dm(l)/v1)**3
     1             *zr(1,i)*zr(1,j)*zr(1,k)
     2             *((4*dm(l)*dm(l) + q + pq)*c0(dm(l),dm(l),dm(l))
     3             + 2*(2*q + pq)*c11(dm(l),dm(l),dm(l))
     4             + 2*(p + 2*pq)*c12(dm(l),dm(l),dm(l))
     5             - 3*b0(p,dm(l),dm(l)))
        call creset
        sss_3vert1 = sss_3vert1 - 24*um(l)*(um(l)/v2)**3
     1             *zr(2,i)*zr(2,j)*zr(2,k)
     2             *((4*um(l)*um(l) + q + pq)*c0(um(l),um(l),um(l))
     3             + 2*(2*q + pq)*c11(um(l),um(l),um(l))
     4             + 2*(p + 2*pq)*c12(um(l),um(l),um(l))
     5             - 3*b0(p,um(l),um(l)))
10      call creset
      return
      end
 
      complex*16 function sss_3vert2(p,q,pq,i,j,k)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      sss_3vert2 = 0
      tmp = 2*(e/sct/2)**6*br(i)*br(j)*br(k)
      do 10 l=1,3
        sss_3vert2 = sss_3vert2 + tmp*c0(vm(l),vm(l),vm(l))
        call creset
10    continue
      do 20 n=1,6
        do 20 l=1,6
          do 20 m=1,6
            tmp = 2*dble(v_lls(l,m,i)*v_lls(m,n,k)*v_lls(n,l,j))
            if (abs(tmp).gt.epsf) then
              sss_3vert2 = sss_3vert2 - tmp*c0(slm(l),slm(n),slm(m))
              call creset
            end if
              tmp = 6*dble(v_uus(l,m,i)*v_uus(m,n,k)*v_uus(n,l,j))
            if (abs(tmp).gt.epsf) then
              sss_3vert2 = sss_3vert2 - tmp*c0(sum(l),sum(n),sum(m))
              call creset
            end if
              tmp = 6*dble(v_dds(l,m,i)*v_dds(m,n,k)*v_dds(n,l,j))
            if (abs(tmp).gt.epsf) then
              sss_3vert2 = sss_3vert2 - tmp*c0(sdm(l),sdm(n),sdm(m))
              call creset
            end if
20    continue
      return
      end
 
      complex*16 function sss_3vert3(p,q,pq,i,j,k)
c     3 charged Higgses (or Goldstones) in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert3 = 0
      do 10 n=1,2
        do 10 m=1,2
          do 10 l=1,2
            sss_3vert3 = sss_3vert3 + 2*(e/st/2)**3
     1                 *dble(v_hhs(l,m,i)*v_hhs(m,n,k)*v_hhs(n,l,j))
     2                 *c0(cm(l),cm(n),cm(m))
10          call creset
      return
      end
 
      complex*16 function sss_3vert4(p,q,pq,i,j,k)
c     3 pseudoscalar Higgses (or Goldstones) in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert4 = 0
      tmp = br(i)*br(j)*br(k)*(e2/sct2/4)**3
      do 10 n=1,2
        do 10 m=1,2
          do 10 l=1,2
            sss_3vert4 = sss_3vert4 + tmp
     1                 *ah(l,m)*ah(m,n)*ah(n,l)*c0(pm(l),pm(n),pm(m))
10          call creset
      return
      end
 
      complex*16 function sss_3vert5(p,q,pq,i,j,k)
c     3 scalar Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert5 = 0
      do 10 n=1,2
        do 10 m=1,2
          do 10 l=1,2
            sss_3vert5 = sss_3vert5 + (e2/sct2/4)**3
     1                 *v_sss(l,m,i)*v_sss(m,n,k)*v_sss(n,l,j)
     2                 *c0(rm(l),rm(n),rm(m))
10          call creset
      return
      end
 
      complex*16 function sss_3vert6(p,q,pq,i,j,k)
c     2 charged Higgses + W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert6 = 0
      do 10 l=1,2
        do 10 n=1,2
          sss_3vert6 = sss_3vert6 - 2*(e/st/2)**3
     1               *v_hhs(j,n,l)*am(i,l)*am(k,n)*( - b0(p,cm(n),wm)
     2               + (cm(l)*cm(l) + p - q)*c0(cm(l),cm(n),wm)
     3               - 2*pq*c11(cm(l),cm(n),wm)
     4               - 2*p*c12(cm(l),cm(n),wm))
          call creset
          sss_3vert6 = sss_3vert6 - 2*(e/st/2)**3
     1               *v_hhs(k,l,n)*am(i,l)*am(j,n)*( - b0(p,cm(n),cm(l))
     2               + (wm2 + 4*pq + 4*q)*c0(wm,cm(n),cm(l))
     3               + 2*(pq + 2*q)*c11(wm,cm(n),cm(l))
     4               + 2*(p + 2*pq)*c12(wm,cm(n),cm(l)))
          call creset
          sss_3vert6 = sss_3vert6 - 2*(e/st/2)**3
     1               *v_hhs(i,l,n)*am(k,n)*am(j,l)*( - b0(p,wm,cm(n))
     2               + (cm(l)*cm(l) - 2*pq - q)*c0(cm(l),wm,cm(n))
     3               + 2*pq*c11(cm(l),wm,cm(n))
     4               + 2*p*c12(cm(l),wm,cm(n)))
          call creset
10    continue
      return
      end
 
      complex*16 function sss_3vert7(p,q,pq,i,j,k)
c     2 pseudoscalar Higgses + Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert7 = 0
      do 10 l=1,2
        do 10 n=1,2
          sss_3vert7 = sss_3vert7 - (e/sct/2)**4
     1               *am(i,l)*am(k,n)*ah(l,n)*br(j)*( - b0(p,pm(n),zm)
     2               + (pm(l)*pm(l) + p - q)*c0(pm(l),pm(n),zm)
     3               - 2*pq*c11(pm(l),pm(n),zm)
     4               - 2*p*c12(pm(l),pm(n),zm))
          call creset
          sss_3vert7 = sss_3vert7 - (e/sct/2)**4
     1               *am(i,l)*am(j,n)*ah(n,l)*br(k)*(- b0(p,pm(n),pm(l))
     2               + (zm2 + 4*pq + 4*q)*c0(zm,pm(n),pm(l))
     3               + 2*(pq + 2*q)*c11(zm,pm(n),pm(l))
     4               + 2*(p + 2*pq)*c12(zm,pm(n),pm(l)))
          call creset
          sss_3vert7 = sss_3vert7 - (e/sct/2)**4
     1               *am(k,n)*am(j,l)*ah(l,n)*br(i)*( - b0(p,zm,pm(n))
     2               + (pm(l)*pm(l) - 2*pq - q)*c0(pm(l),zm,pm(n))
     3               + 2*pq*c11(pm(l),zm,pm(n))
     4               + 2*p*c12(pm(l),zm,pm(n)))
          call creset
10    continue
      return
      end
 
      complex*16 function sss_3vert8(p,q,pq,i,j,k)
c     Charged Higgs + 2 W in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert8 = 0
      do 10 n=1,2
        sss_3vert8 = sss_3vert8 - (e/st)**4*am(k,n)*am(j,n)*cr(i)/4
     1             *((wm2 + 2*q - 2*pq)*c0(wm,cm(n),wm)
     2             + (3*q - pq)*c11(wm,cm(n),wm)
     3             + (3*pq - p)*c12(wm,cm(n),wm) - b0(p,cm(n),wm))
        call creset
        sss_3vert8 = sss_3vert8 - (e/st)**4*am(i,n)*am(j,n)*cr(k)/4
     1             *((cm(n)*cm(n) + q + pq)*c0(cm(n),wm,wm)
     2             - (2*q + pq)*c11(cm(n),wm,wm)
     3             - (2*pq - p)*c12(cm(n),wm,wm) - b0(p,wm,wm))
        call creset
        sss_3vert8 = sss_3vert8 - (e/st)**4*am(i,n)*am(k,n)*cr(j)/4
     1             *((wm2 + 4*p + 2*q + 6*pq)*c0(wm,wm,cm(n))
     2             + (3*q + 4*pq)*c11(wm,wm,cm(n))
     3             + (3*pq + 4*p)*c12(wm,wm,cm(n)) - b0(p,wm,cm(n)))
        call creset
10    continue
      return
      end
 
      complex*16 function sss_3vert9(p,q,pq,i,j,k)
c     pseudoscalar Higgs + 2 Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0,c11,c12
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_3vert9 = 0
      do 10 n=1,2
        sss_3vert9 = sss_3vert9 - (e/sct)**4*am(k,n)*am(j,n)*cr(i)/8
     1             *((zm2 + 2*q - 2*pq)*c0(zm,pm(n),zm)
     2             + (3*q - pq)*c11(zm,pm(n),zm)
     3             + (3*pq - p)*c12(zm,pm(n),zm) - b0(p,pm(n),zm))
        call creset
        sss_3vert9 = sss_3vert9 - (e/sct)**4*am(i,n)*am(j,n)*cr(k)/8
     1             *((pm(n)*pm(n) + q + pq)*c0(pm(n),zm,zm)
     2             - (2*q + pq)*c11(pm(n),zm,zm)
     3             - (2*pq - p)*c12(pm(n),zm,zm) - b0(p,zm,zm))
        call creset
        sss_3vert9 = sss_3vert9 - (e/sct)**4*am(i,n)*am(k,n)*cr(j)/8
     1             *((zm2 + 4*p + 2*q + 6*pq)*c0(zm,zm,pm(n))
     2             + (3*q + 4*pq)*c11(zm,zm,pm(n))
     3             + (3*pq + 4*p)*c12(zm,zm,pm(n)) - b0(p,zm,pm(n)))
        call creset
10    continue
      return
      end
 
      complex*16 function sss_3vert10(p,q,pq,i,j,k)
c     three W and three W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      sss_3vert10 = 60*(e2/st2/4)**3*cr(i)*cr(j)*cr(k)*c0(wm,wm,wm)
      call creset
      return
      end
 
      complex*16 function sss_3vert11(p,q,pq,i,j,k)
c     three Z0 and three Z0-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      sss_3vert11=30*(e2/sct2/4)**3*cr(i)*cr(j)*cr(k)*c0(zm,zm,zm)
      call creset
      return
      end
 
      complex*16 function sss_3vert12(p,q,pq,i,j,k)
c     3 charginos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      complex*16 v_ccs
      complex*16 zpos,zneg
      complex*16 ai,aj,ak,ait,ajt,akt
      complex*16 tmp,tmp1,tmp2,tmp3,tmp4
      double precision mn,ml,mm
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      sss_3vert12 = 0
      s = p + 2*pq + q
      do 10 n=1,2
        do 10 l=1,2
          do 10 m=1,2
            mn  =  fcm(n)
            ml  =  fcm(l)
            mm  =  fcm(m)
            ai  =  v_ccs(l,m,i)
            aj  =  v_ccs(n,l,j)
            ak  =  v_ccs(m,n,k)
            ait =  conjg(v_ccs(m,l,i))
            ajt =  conjg(v_ccs(l,n,j))
            akt =  conjg(v_ccs(n,m,k))
 
      tmp1 = 2*dble(ai*aj*ak + ait*ajt*akt)*mm*mn*ml*c0(ml,mn,mm)
 
      tmp2 = dble(ai*ajt*ak + ait*aj*akt)*mm*( - b0(s,ml,mm)
     1     - b0(p,mn,mm) + (mn*mn + ml*ml - q)*c0(ml,mn,mm))
 
      tmp3 = dble(ait*aj*ak + ai*ajt*akt)*mn*( - b0(p,mn,mm)
     1     - b0(q,ml,mn) + (ml*ml + mm*mm - s)*c0(ml,mn,mm))
 
      tmp4 = dble(ai*aj*akt + ait*ajt*ak)*ml*( - b0(s,ml,mm)
     1     - b0(q,mn,ml) + (mn*mn + mm*mm - p)*c0(ml,mn,mm))
 
      tmp = tmp1 + tmp2 + tmp3 + tmp4
            call creset
10          sss_3vert12 = sss_3vert12 - (e/st)**3*tmp/sq2
      return
      end
 
      complex*16 function sss_3vert13(p,q,pq,i,j,k)
c     3 neutralinos in loop
      implicit double precision (a-h,o-z)
      complex*16 b0,c0
      complex*16 v_nns
      complex*16 zn
      complex*16 ai,aj,ak,ait,ajt,akt
      complex*16 tmp,tmp1,tmp2,tmp3,tmp4
      double precision mn,ml,mm
      common/neut/fnm(4),zn(4,4)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      sss_3vert13 = 0
      s = p + 2*pq + q
      do 10 n=1,4
        do 10 l=1,4
          do 10 m=1,4
            mn  =  fnm(n)
            ml  =  fnm(l)
            mm  =  fnm(m)
            ai  =  v_nns(l,m,i)
            aj  =  v_nns(n,l,j)
            ak  =  v_nns(m,n,k)
            ait =  conjg(v_nns(m,l,i))
            ajt =  conjg(v_nns(l,n,j))
            akt =  conjg(v_nns(n,m,k))
 
      tmp1 = 2*dble(ai*aj*ak + ait*ajt*akt)*mm*mn*ml*c0(ml,mn,mm)
 
      tmp2 = dble(ai*ajt*ak + ait*aj*akt)*mm*( - b0(s,ml,mm)
     1     - b0(p,mn,mm) + (mn*mn + ml*ml - q)*c0(ml,mn,mm))
 
      tmp3 = dble(ait*aj*ak + ai*ajt*akt)*mn*( - b0(p,mn,mm)
     1     - b0(q,ml,mn) + (ml*ml + mm*mm - s)*c0(ml,mn,mm))
 
      tmp4 = dble(ai*aj*akt + ait*ajt*ak)*ml*( - b0(s,ml,mm)
     1     - b0(q,mn,ml) + (mn*mn + mm*mm - p)*c0(ml,mn,mm))
 
      tmp = tmp1 + tmp2 + tmp3 + tmp4

            call creset
10          sss_3vert13 = sss_3vert13 + (e/2/sct)**3*tmp
      return
      end
 
      complex*16 function sss_4vert1(p,q,pq,i,j,k)
c     sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 v_lls,v_uus,v_dds,v_llss,v_uuss,v_ddss
      complex*16 zv,zl,zu,zd
      complex*16 tmp
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      s = p + 2*pq + q
      sss_4vert1 = 0
      do 10 l=1,3
10      sss_4vert1 = sss_4vert1 - br(i)*ar(j,k)*b0(s,vm(l),vm(l))
     1             - br(j)*ar(i,k)*b0(q,vm(l),vm(l))
     2             - br(k)*ar(i,j)*b0(p,vm(l),vm(l))
      tmp = 0
      do 20 m=1,6
        do 20 n=1,6
           tmp = tmp
     1         - v_lls(m,n,i)*v_llss(j,k,n,m)*b0(s,slm(m),slm(n))
     2         - v_lls(m,n,j)*v_llss(i,k,n,m)*b0(q,slm(m),slm(n))
     3         - v_lls(m,n,k)*v_llss(i,j,n,m)*b0(p,slm(m),slm(n))
           tmp = tmp
     1         - 3*v_dds(m,n,i)*v_ddss(j,k,n,m)*b0(s,sdm(m),sdm(n))
     2         - 3*v_dds(m,n,j)*v_ddss(i,k,n,m)*b0(q,sdm(m),sdm(n))
     3         - 3*v_dds(m,n,k)*v_ddss(i,j,n,m)*b0(p,sdm(m),sdm(n))
20         tmp = tmp
     1         - 3*v_uus(m,n,i)*v_uuss(j,k,n,m)*b0(s,sum(m),sum(n))
     2         - 3*v_uus(m,n,j)*v_uuss(i,k,n,m)*b0(q,sum(m),sum(n))
     3         - 3*v_uus(m,n,k)*v_uuss(i,j,n,m)*b0(p,sum(m),sum(n))
      sss_4vert1 = (e/sct/2)**4*sss_4vert1 + tmp
      return
      end
 
      complex*16 function sss_4vert2(p,q,pq,i,j,k)
c     2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_4vert2 = 0
      s = p + 2*pq + q
      do 10 m=1,2
        do 10 n=1,2
10        sss_4vert2 = sss_4vert2 - (e/sct)**4*ah(m,n)*ah(n,m)/32
     1               *(br(i)*ar(j,k)*b0(s,pm(m),pm(n))
     2               + br(j)*ar(i,k)*b0(q,pm(m),pm(n))
     3               + br(k)*ar(i,j)*b0(p,pm(m),pm(n)))
      return
      end
 
      complex*16 function sss_4vert3(p,q,pq,i,j,k)
c     2 scalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_4vert3 = 0
      s = p + 2*pq + q
      do 10 m=1,2
        do 10 n=1,2
10        sss_4vert3 = sss_4vert3
     1               - v_sss(j,m,n)*v_ssss(n,m,i,k)*b0(q,rm(m),rm(n))
     2               - v_sss(k,m,n)*v_ssss(n,m,i,j)*b0(p,rm(m),rm(n))
     3               - v_sss(i,m,n)*v_ssss(n,m,j,k)*b0(s,rm(m),rm(n))
      sss_4vert3 = sss_4vert3*(e/sct)**4/32
      return
      end
 
      complex*16 function sss_4vert4(p,q,pq,i,j,k)
c     2 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      s = p + 2*pq + q
      sss_4vert4 = 0
      do 10 m=1,2
        do 10 n=1,2
10        sss_4vert4 = sss_4vert4
     1               - v_hhs(j,m,n)*v_hhss(i,k,n,m)*b0(q,cm(n),cm(m))
     2               - v_hhs(k,m,n)*v_hhss(i,j,n,m)*b0(p,cm(n),cm(m))
     3               - v_hhs(i,m,n)*v_hhss(j,k,n,m)*b0(s,cm(n),cm(m))
      sss_4vert4 = sss_4vert4*(e/st/2)**3
      return
      end
 
      complex*16 function sss_4vert5(p,q,pq,i,j,k)
c     2 W bosons or Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      sss_4vert5 = 0
      s = p + q + 2*pq
      if (j.eq.k) then
        sss_4vert5 = sss_4vert5
     1             - cr(i)*(2*b0(s,wm,wm) + b0(s,zm,zm)/ct2/ct2)
      end if
      if (i.eq.k) then
        sss_4vert5 = sss_4vert5
     1             - cr(j)*(2*b0(q,wm,wm) + b0(q,zm,zm)/ct2/ct2)
      end if
      if (i.eq.j) then
        sss_4vert5 = sss_4vert5
     1             - cr(k)*(2*b0(p,wm,wm) + b0(p,zm,zm)/ct2/ct2)
      end if
      sss_4vert5 = sss_4vert5*(e/st)**4/2
      return
      end
 
      complex*16 function sss_vert(p,q,pq,i,j,k)
c     Full bare SSS vertex formfactor
      implicit double precision (a-h,o-z)
      complex*16 sss_3vert1,sss_3vert2, sss_3vert3, sss_3vert4,
     1           sss_3vert5,sss_3vert6, sss_3vert7, sss_3vert8,
     2           sss_3vert9,sss_3vert10,sss_3vert11,sss_3vert12,
     3           sss_3vert13
      complex*16 sss_4vert1,sss_4vert2,sss_4vert3,sss_4vert4,sss_4vert5
      logical vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      sss_vert = (0,0)
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) sss_vert = sss_vert + sss_3vert1(p,q,pq,i,j,k)
      if (is.eq.1) sss_vert = sss_vert + sss_3vert2(p,q,pq,i,j,k)
     1                                 + sss_4vert1(p,q,pq,i,j,k)
      if (ig.eq.1) sss_vert = sss_vert + sss_3vert3(p,q,pq,i,j,k)
     1     + sss_3vert4(p,q,pq,i,j,k)  + sss_3vert5(p,q,pq,i,j,k)
     2     + sss_3vert6(p,q,pq,i,j,k)  + sss_3vert7(p,q,pq,i,j,k)
     3     + sss_3vert8(p,q,pq,i,j,k)  + sss_3vert9(p,q,pq,i,j,k)
     4     + sss_3vert10(p,q,pq,i,j,k) + sss_3vert11(p,q,pq,i,j,k)
     5     + sss_4vert2(p,q,pq,i,j,k)  + sss_4vert3(p,q,pq,i,j,k)
     6     + sss_4vert4(p,q,pq,i,j,k)  + sss_4vert5(p,q,pq,i,j,k)
      if (ic.eq.1) sss_vert = sss_vert + sss_3vert12(p,q,pq,i,j,k)
      if (in.eq.1) sss_vert = sss_vert + sss_3vert13(p,q,pq,i,j,k)
      sss_vert = sss_vert/16/pi/pi
      return
      end
 
      complex*16 function sss_ren(p,q,pq,i,j,k)
c     TREE LEVEL EXPRESSION + full renormalized SSS vertex formfactor
      implicit double precision (a-h,o-z)
      complex*16 sss_vert
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      sss_ren = e2/sct2/4*v_sss(i,j,k)
      if (.not.vstat) return
      sss_ren = sss_ren - e2/sct2/4*(dv1/v1 - 2*ct2*dz2 
     1        + 3*ct2*dza + st2*dzb)*v_sss(i,j,k)
     2        + e2/sct2/4*(6*dzh1*v1*zr(1,i)*zr(1,j)*zr(1,k)
     3                   + 6*dzh2*v2*zr(2,i)*zr(2,j)*zr(2,k)
     4        - (dzh1 + dzh2)*(v1*(zr(1,i)*zr(2,j)*zr(2,k)
     5                           + zr(2,i)*zr(1,j)*zr(2,k)
     6                           + zr(2,i)*zr(2,j)*zr(1,k))
     7                       + v2*(zr(2,i)*zr(1,j)*zr(1,k)
     8                           + zr(1,i)*zr(2,j)*zr(1,k)
     9                           + zr(1,i)*zr(1,j)*zr(2,k))))
     a        + sss_vert(p,q,pq,i,j,k)
      return
      end




