c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: VH_DEF.FOR
c     Last revised: 25: 4:1996 (J.R.)
c     Vertices UDH,UUHH,DDHH added
c     Leading one-loop correction to the vertex HHS added
 
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains definitions of more complicated mixing        c
c     matrices and expressions for Higgs boson vertices                c
c     Compare with the paper: J.Rosiek@Phys.Rev.D41(1990)p.3464;       c
c     erratum, hep-ph/9511250                                          c
c     Common factors like e/2/sct etc. factorized from expressions     c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      double precision function ah(i,j)
c     AH mixing matrix definition
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ah = zh(1,i)*zh(1,j) - zh(2,i)*zh(2,j)
      return
      end
 
      double precision function ar(i,j)
c     AR mixing matrix definition
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ar = zr(1,i)*zr(1,j) - zr(2,i)*zr(2,j)
      return
      end
 
      double precision function am(i,j)
c     AM mixing matrix definition
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      am = zr(1,i)*zh(1,j) - zr(2,i)*zh(2,j)
      return
      end
 
      double precision function ap(i,j)
c     AP mixing matrix definition
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      ap = zr(1,i)*zh(2,j) + zr(2,i)*zh(1,j)
      return
      end
 
      double precision function br(i)
c     BR mixing matrix definition
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      br = v1*zr(1,i) - v2*zr(2,i)
      return
      end
 
      double precision function cr(i)
c     CR mixing matrix definition - v(i)*zr(i,j)
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      cr = v1*zr(1,i) + v2*zr(2,i)
      return
      end
 
      complex*16 function v_nns(i,j,k)
c     Scalar - 2 neutralino vertex
      implicit double precision (a-h,o-z)
      complex*16 zn
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      v_nns = ((zr(1,k)*zn(3,i)-zr(2,k)*zn(4,i))*(zn(1,j)*st-zn(2,j)*ct)
     1      + (zr(1,k)*zn(3,j)-zr(2,k)*zn(4,j))*(zn(1,i)*st-zn(2,i)*ct))
      return
      end
 
      complex*16 function v_ccs(i,j,k)
c     Scalar - 2 chargino vertex
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      v_ccs = zr(1,k)*zpos(1,i)*zneg(2,j) + zr(2,k)*zpos(2,i)*zneg(1,j)
      return
      end
 
      complex*16 function v_lls(i,j,k)
c     Scalar - 2 slepton vertex
      implicit double precision (a-h,o-z)
      complex*16 vlls,vi_lls
      logical init_lls
      common/rsl/vlls(6,6,2),init_lls
      if (init_lls) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vlls(l,m,n) = vi_lls(l,m,n)
        init_lls = .false.
      end if
      v_lls = vlls(i,j,k)
      return
      end
 
      complex*16 function v_uus(i,j,k)
c     Scalar - 2 u-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vuus,vi_uus
      logical init_uus
      common/rsu/vuus(6,6,2),init_uus
      if (init_uus) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vuus(l,m,n) = vi_uus(l,m,n)
        init_uus = .false.
      end if
      v_uus = vuus(i,j,k)
      return
      end
 
      complex*16 function v_dds(i,j,k)
c     Scalar - 2 d-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vdds,vi_dds
      logical init_dds
      common/rsd/vdds(6,6,2),init_dds
      if (init_dds) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vdds(l,m,n) = vi_dds(l,m,n)
        init_dds = .false.
      end if
      v_dds = vdds(i,j,k)
      return
      end
 
      complex*16 function vi_lls(i,j,k)
c     Scalar - 2 slepton vertex initialization
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      vi_lls = e2/2/ct2*br(k)*del(i,j)
      do 10 l=1,3
        vi_lls = vi_lls+e2/4/sct2*br(k)*(1-4*st2)*conjg(zl(l,i))*zl(l,j)
        vi_lls = vi_lls-2*em(l)**2/v1*zr(1,k)
     1        *(conjg(zl(l,i))*zl(l,j)+conjg(zl(l+3,i))*zl(l+3,j))
        vi_lls = vi_lls + em(l)/v1*zr(2,k)
     1        *(conjg(h*zl(l,i))*zl(l+3,j)+h*zl(l,j)*conjg(zl(l+3,i)))
        do 10 m=1,3
          vi_lls = vi_lls - zr(1,k)/sq2
     1          *(conjg(ls(l,m)*zl(m+3,i))*zl(l,j)
     2          + ls(l,m)*zl(m+3,j)*conjg(zl(l,i)))
10        vi_lls = vi_lls + zr(2,k)/sq2
     1          *(conjg(ks(l,m)*zl(m+3,i))*zl(l,j)
     2          + ks(l,m)*zl(m+3,j)*conjg(zl(l,i)))
      return
      end
 
      complex*16 function vi_dds(i,j,k)
c     Scalar - 2 d-squark vertex initialization
      implicit double precision (a-h,o-z)
      complex*16 zd,zu,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      vi_dds = e2/6/ct2*br(k)*del(i,j)
      do 10 l=1,3
        vi_dds = vi_dds
     1        + e2/12/sct2*br(k)*(3 - 4*st2)*conjg(zd(l,i))*zd(l,j)
        vi_dds = vi_dds - 2*dm(l)**2/v1*zr(1,k)
     1        *(conjg(zd(l,i))*zd(l,j) + conjg(zd(l+3,i))*zd(l+3,j))
        vi_dds = vi_dds + dm(l)/v1*zr(2,k)
     1        *(conjg(h*zd(l,i))*zd(l+3,j) + h*zd(l,j)*conjg(zd(l+3,i)))
        do 10 m=1,3
          vi_dds = vi_dds - zr(1,k)/sq2
     1          *(conjg(ds(l,m)*zd(m+3,i))*zd(l,j)
     2          + ds(l,m)*zd(m+3,j)*conjg(zd(l,i)))
10        vi_dds = vi_dds + zr(2,k)/sq2
     1          *(conjg(es(l,m)*zd(m+3,i))*zd(l,j)
     2          + es(l,m)*zd(m+3,j)*conjg(zd(l,i)))
      return
      end
 
      complex*16 function vi_uus(i,j,k)
c     Scalar - 2 u-squark vertex initialization
      implicit double precision (a-h,o-z)
      complex*16 zd,zu,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      vi_uus = -e2/3/ct2*br(k)*del(i,j)
      do 10 l=1,3
        vi_uus = vi_uus
     1          - e2/12/sct2*br(k)*(3 - 8*st2)*conjg(zu(l,i))*zu(l,j)
        vi_uus = vi_uus - 2*um(l)**2/v2*zr(2,k)
     1        *(conjg(zu(l,i))*zu(l,j) + conjg(zu(l+3,i))*zu(l+3,j))
        vi_uus = vi_uus + um(l)/v2*zr(1,k)
     1        *(conjg(h*zu(l+3,i))*zu(l,j) + h*zu(l+3,j)*conjg(zu(l,i)))
        do 10 m=1,3
          vi_uus = vi_uus + zr(2,k)/sq2
     1          *(conjg(us(l,m)*zu(l,i))*zu(m+3,j)
     2          + us(l,m)*zu(l,j)*conjg(zu(m+3,i)))
10        vi_uus = vi_uus + zr(1,k)/sq2
     1          *(conjg(ws(l,m)*zu(l,i))*zu(m+3,j)
     2          + ws(l,m)*zu(l,j)*conjg(zu(m+3,i)))
      return
      end
 
      double precision function v_sss(i,j,k)
c     3 - scalar vertex
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      v_sss = 3*v1*zr(1,i)*zr(1,j)*zr(1,k)
     1      + 3*v2*zr(2,i)*zr(2,j)*zr(2,k)
     2      - v1*(zr(2,i)*zr(2,j)*zr(1,k) + zr(2,i)*zr(1,j)*zr(2,k)
     3      + zr(1,i)*zr(2,j)*zr(2,k))
     4      - v2*(zr(1,i)*zr(1,j)*zr(2,k) + zr(1,i)*zr(2,j)*zr(1,k)
     5      + zr(2,i)*zr(1,j)*zr(1,k))
      return
      end
 
      double precision function v_hhs(i,j,k)
c     Scalar - 2 charged Higgs vertex
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/delta/d(6,6)
      v_hhs = e/2/st/ct2*ah(j,k)*br(i)
     1       + wm*(ap(i,j)*d(1,k) + ap(i,k)*d(1,j))
c     Leading second order correction added:
     2       + shh_vert(i,j,k)
c     mt^4 term:  
c     - (um(3)*um(3)/pi/v2)**2*st/e/v2*zr(2,i)*zh(2,j)*zh(2,k)
c     *log(um(3)*um(3)/sum(1)/sum(6))
      return
      end
 
      double precision function v_ssss(i,j,k,l)
c     4 - scalar vertex
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      v_ssss = 3*zr(1,i)*zr(1,j)*zr(1,k)*zr(1,l)
     1       + 3*zr(2,i)*zr(2,j)*zr(2,k)*zr(2,l)
     2       - zr(1,i)*zr(1,j)*zr(2,k)*zr(2,l)
     3       - zr(1,i)*zr(2,j)*zr(1,k)*zr(2,l)
     4       - zr(1,i)*zr(2,j)*zr(2,k)*zr(1,l)
     5       - zr(2,i)*zr(1,j)*zr(1,k)*zr(2,l)
     6       - zr(2,i)*zr(1,j)*zr(2,k)*zr(1,l)
     7       - zr(2,i)*zr(2,j)*zr(1,k)*zr(1,l)
      return
      end
 
      double precision function v_hhss(i,j,k,l)
c     2 charged Higgses + 2 scalars vertex
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      v_hhss = ar(i,j)*ah(k,l)/ct2 + ap(i,k)*ap(j,l) + ap(i,l)*ap(j,k)
      return
      end
 
      complex*16 function v_llss(i,j,k,l)
c     2 scalar - 2 slepton vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_llss = e2/2/ct2*ar(i,j)*del(k,l)
      do 10 m=1,3
        v_llss = v_llss + e2/4/sct2*ar(i,j)*(1 - 4*st2)
     1         *conjg(zl(m,k))*zl(m,l)
10      v_llss = v_llss - 2*em(m)**2/v1/v1*zr(1,i)*zr(1,j)
     1        *(conjg(zl(m,k))*zl(m,l) + conjg(zl(m+3,k))*zl(m+3,l))
      return
      end
 
      complex*16 function v_uuss(i,j,k,l)
c     2 scalar - 2 U-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_uuss = - e2/3/ct2*ar(i,j)*del(k,l)
      do 10 m=1,3
        v_uuss = v_uuss - e2/12/sct2*ar(i,j)*(3 - 8*st2)
     1         *conjg(zu(m,k))*zu(m,l)
10      v_uuss = v_uuss - 2*um(m)**2/v2/v2*zr(2,i)*zr(2,j)
     1        *(conjg(zu(m,k))*zu(m,l) + conjg(zu(m+3,k))*zu(m+3,l))
      return
      end
 
      complex*16 function v_ddss(i,j,k,l)
c     2 scalar - 2 D-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_ddss = e2/6/ct2*ar(i,j)*del(k,l)
      do 10 m=1,3
        v_ddss = v_ddss + e2/12/sct2*ar(i,j)*(3 - 4*st2)
     1         *conjg(zd(m,k))*zd(m,l)
10      v_ddss = v_ddss - 2*dm(m)**2/v1/v1*zr(1,i)*zr(1,j)
     1        *(conjg(zd(m,k))*zd(m,l) + conjg(zd(m+3,k))*zd(m+3,l))
      return
      end
 
      complex*16 function v_llp(i,j,k)
c     Pseudoscalar - 2 slepton vertex
      implicit double precision (a-h,o-z)
      complex*16 vllp,vi_llp
      logical init_llp
      common/psl/vllp(6,6,2),init_llp
      if (init_llp) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vllp(l,m,n) = vi_llp(l,m,n)
        init_llp = .false.
      end if
      v_llp = vllp(i,j,k)
      return
      end
 
      complex*16 function v_uup(i,j,k)
c     Pseudoscalar - 2 u-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vuup,vi_uup
      logical init_uup
      common/psu/vuup(6,6,2),init_uup
      if (init_uup) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vuup(l,m,n) = vi_uup(l,m,n)
        init_uup = .false.
      end if
      v_uup = vuup(i,j,k)
      return
      end
 
      complex*16 function v_ddp(i,j,k)
c     Pseudoscalar - 2 d-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vddp,vi_ddp
      logical init_ddp
      common/psd/vddp(6,6,2),init_ddp
      if (init_ddp) then
        do 10 l=1,6
          do 10 m=1,6
            do 10 n=1,2
10            vddp(l,m,n) = vi_ddp(l,m,n)
        init_ddp = .false.
      end if
      v_ddp = vddp(i,j,k)
      return
      end
 
      complex*16 function vi_llp(i,j,k)
c     Pseudoscalar - 2 slepton vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vi_llp = 0
      do 10 l=1,3
        vi_llp = vi_llp + em(l)/v1*zh(2,k)
     1        *(conjg(h*zl(l,i))*zl(l+3,j) - h*zl(l,j)*conjg(zl(l+3,i)))
        do 10 m=1,3
          vi_llp = vi_llp - zh(1,k)*(conjg(ls(l,m)*zl(m+3,i))*zl(l,j)
     1          - ls(l,m)*zl(m+3,j)*conjg(zl(l,i)))/sq2
10        vi_llp = vi_llp - zh(2,k)*(conjg(ks(l,m)*zl(m+3,i))*zl(l,j)
     1          - ks(l,m)*zl(m+3,j)*conjg(zl(l,i)))/sq2
      return
      end
 
      complex*16 function vi_ddp(i,j,k)
c     Pseudoscalar - 2 D-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 zd,zu,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vi_ddp = 0
      do 10 l=1,3
        vi_ddp = vi_ddp + dm(l)/v1*zh(2,k)
     1        *(conjg(h*zd(l,i))*zd(l+3,j) - h*zd(l,j)*conjg(zd(l+3,i)))
        do 10 m=1,3
          vi_ddp = vi_ddp - zh(1,k)*(conjg(ds(l,m)*zd(m+3,i))*zd(l,j)
     1          - ds(l,m)*zd(m+3,j)*conjg(zd(l,i)))/sq2
10        vi_ddp = vi_ddp - zh(2,k)*(conjg(es(l,m)*zd(m+3,i))*zd(l,j)
     1          - es(l,m)*zd(m+3,j)*conjg(zd(l,i)))/sq2
      return
      end
 
      complex*16 function vi_uup(i,j,k)
c     Pseudoscalar - 2 U-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 zd,zu,h,ls,ks,ds,es,us,ws
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      vi_uup = 0
      do 10 l=1,3
        vi_uup = vi_uup + um(l)/v2*zh(1,k)
     1        *(conjg(h*zu(l+3,i))*zu(l,j) - h*zu(l+3,j)*conjg(zu(l,i)))
        do 10 m=1,3
          vi_uup = vi_uup + zh(2,k)*(conjg(us(l,m)*zu(l,i))*zu(m+3,j)
     1          - us(l,m)*zu(l,j)*conjg(zu(m+3,i)))/sq2
10        vi_uup = vi_uup - zh(1,k)*(conjg(ws(l,m)*zu(l,i))*zu(m+3,j)
     1          - ws(l,m)*zu(l,j)*conjg(zu(m+3,i)))/sq2
      return
      end
 
      complex*16 function v_nnp(i,j,k)
c     Pseudoscalar - 2 neutralino vertex
      implicit double precision (a-h,o-z)
      complex*16 zn
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/neut/fnm(4),zn(4,4)
      v_nnp = ((zh(1,k)*zn(3,j)-zh(2,k)*zn(4,j))*(zn(1,i)*st-zn(2,i)*ct)
     1      + (zh(1,k)*zn(3,i)-zh(2,k)*zn(4,i))*(zn(1,j)*st-zn(2,j)*ct))
      return
      end
 
      complex*16 function v_ccp(i,j,k)
c     Pseudoscalar - 2 chargino vertex
      implicit double precision (a-h,o-z)
      complex*16 zpos,zneg
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      v_ccp = zh(1,k)*zpos(1,i)*zneg(2,j) + zh(2,k)*zpos(2,i)*zneg(1,j)
      return
      end
 
      double precision function v_pppp(i,j,k,l)
c     4 - pseudoscalar vertex
      implicit double precision (a-h,o-z)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      v_pppp = 3*zh(1,i)*zh(1,j)*zh(1,k)*zh(1,l)
     1       + 3*zh(2,i)*zh(2,j)*zh(2,k)*zh(2,l)
     2       - zh(1,i)*zh(1,j)*zh(2,k)*zh(2,l)
     3       - zh(1,i)*zh(2,j)*zh(1,k)*zh(2,l)
     4       - zh(1,i)*zh(2,j)*zh(2,k)*zh(1,l)
     5       - zh(2,i)*zh(1,j)*zh(1,k)*zh(2,l)
     6       - zh(2,i)*zh(1,j)*zh(2,k)*zh(1,l)
     7       - zh(2,i)*zh(2,j)*zh(1,k)*zh(1,l)
      return
      end
 
      double precision function v_hhpp(i,j,k,l)
c     2 charged Higgses + 2 pseudoscalars vertex
      implicit double precision (a-h,o-z)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/eps/ep(2,2)
      v_hhpp = ah(i,j)*ah(k,l)/ct2 + ep(i,k)*ep(j,l) + ep(i,l)*ep(j,k)
      return
      end
 
      complex*16 function v_llpp(i,j,k,l)
c     2 pseudoscalars - 2 sleptons vertex
      implicit double precision (a-h,o-z)
      complex*16 zv,zl
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_llpp = e2/2/ct2*ah(i,j)*del(k,l)
      do 10 m=1,3
        v_llpp = v_llpp + e2/4/sct2*ah(i,j)*(1-4*st2)
     1         *conjg(zl(m,k))*zl(m,l)
10      v_llpp = v_llpp - 2*em(m)**2/v1/v1*zh(1,i)*zh(1,j)
     1        *(conjg(zl(m,k))*zl(m,l)+conjg(zl(m+3,k))*zl(m+3,l))
      return
      end
 
      complex*16 function v_uupp(i,j,k,l)
c     2 pseudoscalars - 2 U-squarks vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_uupp = -e2/3/ct2*ah(i,j)*del(k,l)
      do 10 m=1,3
        v_uupp = v_uupp - e2/12/sct2*ah(i,j)*(3-8*st2)
     1         *conjg(zu(m,k))*zu(m,l)
10      v_uupp = v_uupp - 2*um(m)**2/v2/v2*zh(2,i)*zh(2,j)
     1        *(conjg(zu(m,k))*zu(m,l)+conjg(zu(m+3,k))*zu(m+3,l))
      return
      end
 
      complex*16 function v_ddpp(i,j,k,l)
c     2 pseudoscalars - 2 D-squarks vertex
      implicit double precision (a-h,o-z)
      complex*16 zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      v_ddpp = e2/6/ct2*ah(i,j)*del(k,l)
      do 10 m=1,3
        v_ddpp = v_ddpp + e2/12/sct2*ah(i,j)*(3-4*st2)
     1         *conjg(zd(m,k))*zd(m,l)
10      v_ddpp = v_ddpp - 2*dm(m)**2/v1/v1*zh(1,i)*zh(1,j)
     1        *(conjg(zd(m,k))*zd(m,l)+conjg(zd(m+3,k))*zd(m+3,l))
      return
      end

      complex*16 function v_udh(i,j,k)
c     Charged Higgs - u-squark - d-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vudh,vi_udh
      logical init_udh
      common/hud/vudh(6,6,2),init_udh
      if (init_udh) then
         do 10 l=1,6
            do 10 m=1,6
               do 10 n=1,2
 10               vudh(l,m,n) = vi_udh(l,m,n)
         init_udh = .false.
      end if
      v_udh = vudh(i,j,k)
      return
      end
 
      complex*16 function vi_udh(i,j,k)
c     Charged Higgs - u-squark - d-squark vertex initialization
      implicit double precision (a-h,o-z)
      complex*16 zd,zu,h,ls,ks,ds,es,us,ws,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hpar/hm1,hm2,hs,h
      common/soft/ls(3,3),ks(3,3),ds(3,3),es(3,3),us(3,3),ws(3,3)
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/km_mat/ckm(3,3)
      common/vev/v1,v2
      common/delta/del(6,6)
      vi_udh = 0
      do 10 l=1,3
        do 10 m=1,3
          vi_udh = vi_udh + sq2*conjg(ckm(l,m))*(( - e2/4/st2*cr(k) 
     $          + dm(l)*dm(l)/v1*zh(1,k) + um(m)*um(m)/v2*zh(2,k))
     $          * conjg(zd(l,j)*zu(m,i))
     $          + 2*wm*st/e*del(1,k)*um(m)*dm(l)/v1/v2
     $          * conjg(zd(l+3,j)*zu(m+3,i))
     $          + um(m)/v2*zh(1,k)*conjg(h*zd(l,j)*zu(m+3,i))
     $          + dm(l)/v1*zh(2,k)*h*conjg(zd(l+3,j)*zu(m,i)))
          do 10 n=1,3
 10         vi_udh = vi_udh + (ws(n,m)*zh(1,k) - us(n,m)*zh(2,k))
     $            * conjg(zd(l,j)*zu(m+3,i)*ckm(l,n))
     $            + conjg((ds(n,l)*zh(1,k) + es(n,l)*zh(2,k))
     $            * zd(l+3,j)*zu(m,i)*ckm(n,m))
      return
      end
 
      complex*16 function v_ddhh(i,j,k,l)
c     2 charged Higgs - 2 d-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vddhh,vi_ddhh
      integer o,p
      logical init_ddhh
      common/hhdd/vddhh(6,6,2,2),init_ddhh
      if (init_ddhh) then
         do 10 m=1,6
            do 10 n=1,6
               do 10 o=1,2
                  do 10 p=1,2
 10                  vddhh(m,n,o,p) = vi_ddhh(m,n,o,p)
         init_ddhh = .false.
      end if
      v_ddhh = vddhh(i,j,k,l)
      return
      end
 
      complex*16 function vi_ddhh(i,j,k,l)
c     2 charged Higgs - 2 D-squark vertex initialization
      implicit double precision (a-h,o-z)
      integer o
      complex*16 zu,zd,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      common/km_mat/ckm(3,3)
      v_ddhh = e2/6/ct2*ah(k,l)*del(i,j)
      do 10 m=1,3
        vi_ddhh = vi_ddhh - e2/12/sct2*ah(k,l)*(3 - 2*st2)
     1        * conjg(zd(m,i))*zd(m,j)
     2        - 2*dm(m)*dm(m)/v1/v1*zh(1,k)*zh(1,l)
     3        * conjg(zd(m+3,i))*zd(m+3,j)
        do 10 n=1,3
          do 10 o=1,3  
 10         vi_ddhh = vi_ddhh - 2*um(n)*um(n)/v2/v2*zh(2,k)*zh(2,l)
     1        * ckm(m,n)*zd(m,j)*conjg(ckm(o,n)*zd(o,i))
      return
      end
 
      complex*16 function v_uuhh(i,j,k,l)
c     2 charged Higgs - 2 u-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vuuhh,vi_uuhh
      integer o,p
      logical init_uuhh
      common/hhuu/vuuhh(6,6,2,2),init_uuhh
      if (init_uuhh) then
         do 10 m=1,6
            do 10 n=1,6
               do 10 o=1,2
                  do 10 p=1,2
 10                  vuuhh(m,n,o,p) = vi_uuhh(m,n,o,p)
         init_uuhh = .false.
      end if
      v_uuhh = vuuhh(i,j,k,l)
      return
      end
 
      complex*16 function vi_uuhh(i,j,k,l)
c     2 charged Higgs - 2 u-squark vertex initialization
      implicit double precision (a-h,o-z)
      integer o
      complex*16 zu,zd,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      common/km_mat/ckm(3,3)
      v_uuhh = - e2/3/ct2*ah(k,l)*del(i,j)
      do 10 m=1,3
        vi_uuhh = vi_uuhh + e2/12/sct2*ah(k,l)*(3 + 2*st2)
     1        * conjg(zu(m,i))*zu(m,j)
     2        - 2*um(m)*um(m)/v2/v2*zh(2,k)*zh(2,l)
     3        * conjg(zu(m+3,i))*zu(m+3,j)
        do 10 n=1,3
          do 10 o=1,3  
 10         vi_uuhh = vi_uuhh - 2*dm(m)*dm(m)/v1/v1*zh(1,k)*zh(1,l)
     1        * ckm(m,n)*zu(n,j)*conjg(ckm(m,o)*zu(o,i))
      return
      end
 

      complex*16 function v_udhs(i,j,k,l)
c     Charged Higgs - scalar - u-squark -d-squark vertex
      implicit double precision (a-h,o-z)
      complex*16 vudhs,vi_udhs
      integer o,p
      logical init_udhs
      common/hsud/vudhs(6,6,2,2),init_udhs
      if (init_udhs) then
         do 10 m=1,6
            do 10 n=1,6
               do 10 o=1,2
                  do 10 p=1,2
 10                  vudhs(m,n,o,p) = vi_udhs(m,n,o,p)
         init_udhs = .false.
      end if
      v_udhs = vudhs(i,j,k,l)
      return
      end
 
      complex*16 function vi_udhs(i,j,k,l)
c     2 charged Higgs - 2 u-squark vertex initialization
      implicit double precision (a-h,o-z)
      complex*16 zu,zd,ckm
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/delta/del(6,6)
      common/km_mat/ckm(3,3)
      vi_udhs = 0
      do 10 m=1,3
       do 10 n=1,3
 10      vi_udhs = vi_udhs + sq2*((um(n)*um(n)/v2/v2*zh(2,k)*zr(2,l)
     $         + dm(m)*dm(m)/v1/v1*zh(1,k)*zr(1,l) - e2/4/st2
     $         *(zh(1,k)*zr(1,l) + zh(2,k)*zr(2,l)))*zu(n,i)*zd(m,j)
     $         + um(n)*dm(m)/v1/v2*ap(l,k)*zu(n+3,i)*zd(m+3,j))*ckm(m,n)
      return
      end
 



