c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: Z_EXT.FOR
c     Released: 1:11:1992(J.R.)
c     Last revised 11: 4:1994(J.R.)
c     Calculation for gauge and Higgs bosons separated.

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains routines for Evaluation of "Z factors"        c
c     on external Higgs, Z and W boson lines.                          c
c     See: Chankowski,Pokorski,Rosiek, Nucl.Phys.B423(1994)p.437,      c
c     available as hep-ph/9303309.                                     c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine z_ext(eps,ierr)
c     Evaluation of Z factors on external Z and W and Higgs lines
      implicit double precision (a-h,o-z)
      call zg_ext(eps)
      call zh_ext(eps,ierr)
      return
      end
 
      subroutine zg_ext(eps)
c     Evaluation of Z factor on external Z and W lines
      implicit double precision (a-h,o-z)
      complex*16 zms,zmp,z1,z2
      complex*16 zt_ren,wt_ren,ft_ren,fzt_ren
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      zeps = eps
c     Z0 on the external line (mixing with photon included)
      q1 = zm2*(1 + zeps)
      q2 = zm2*(1 - zeps)
      z1 = zt_ren(q1) + fzt_ren(q1)**2/(q1 - ft_ren(q1))
      z2 = zt_ren(q2) + fzt_ren(q2)**2/(q2 - ft_ren(q2))
      zz = 1/sqrt(1 - dble(z1 - z2)/2/zeps/zm2)
c     W on the external line
      zw = 1/sqrt(1 - dble(wt_ren(wm2*(1 + eps))
     1                  -  wt_ren(wm2*(1 - eps)))/2/eps/wm2)
      return
      end
 
      subroutine zh_ext(eps,ierr)
c     Evaluation of Z factors on external skalar and pseudoscalar lines
c     ierr = 0:   calculations succesful
c     ierr = 1:   negative residuum of (pseudo)scalar propagator
      implicit double precision (a-h,o-z)
      complex*16 zms,zmp,z1,z2
      complex*16 s_ren,p_ren
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/hm_phys/frm(2),frm2(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/zext/zs(2),zms(2,2),zp(2),zmp(2,2),zz,zw,zeps
      zeps = eps
      ierr = 0
      do 10 i=1,2
        j = 3 - i
c     Scalar with no mixing
        q = frm2(i)
        q1 = q*(1 + zeps)
        q2 = q*(1 - zeps)
        z1 = s_ren(q1,i,i)
     1     + s_ren(q1,i,j)**2/(q1 - rm(j)**2 - s_ren(q1,j,j))
        z2 = s_ren(q2,i,i)
     1     + s_ren(q2,i,j)**2/(q2 - rm(j)**2 - s_ren(q2,j,j))
        zs(i) = 1 - dble(z1 - z2)/2/zeps/q
        if (zs(i).lt.0) ierr = 1
        zs(i) = 1/sqrt(abs(zs(i)))
c     Scalar with mixing
        zms(i,1) = (1,0)
        zms(i,2) = s_ren(q,i,j)/(q - rm(j)**2 - s_ren(q,j,j))
c     Pseudocalar with no mixing
        q = pm(i)*pm(i)
        q1 = q*(1 + zeps)
        q2 = q*(1 - zeps)
        z1 = p_ren(q1,i,i)
     1     + p_ren(q1,i,j)**2/(q1 - pm(j)**2 - p_ren(q1,j,j))
        z2 = p_ren(q2,i,i)
     1    + p_ren(q2,i,j)**2/(q2 - pm(j)**2 - p_ren(q2,j,j))
        zp(i) = 1 - dble(z1 - z2)/2/zeps/q
        if (zp(i).lt.0) ierr = 1
        zp(i) = 1/sqrt(abs(zp(i)))
c     Pseudoscalar with mixing
        zmp(i,1) = (1,0)
10      zmp(i,2) = p_ren(q,i,j)/(q - pm(j)**2 - p_ren(q,j,j))
      return
      end
 
      integer function i_sup(i,j)
c     Definition of "supplementary" Higgs index for easier resummation
c     of different mixing contribution on external lines
      if (j.eq.1) then
        i_sup = i
      else if (j.eq.2) then
        i_sup = 3 - i
      else
        stop 'Second index in I_SUP outside allowed range!'
      end if
      return
      end



