c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZEE_VERT.FOR
c     Released: 23: 2:1994(J.R.)
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains Z-lepton-lepton vertex formfactors           c
c                                                                     c
c     Incoming Z0:          momentum (p+q)(\mu)                       c
c     Outgoing antilepton:  momentum  p                               c
c     Outgoing lepton:      momentum  q                               c
c                                                                     c
c                              V3            _                        c
c                               ____________ l (i)                    c
c                             /|      p (outgoing)                    c
c                        L2 /  |                                      c
c                         /    |                                      c
c        Z^0_{\mu}      /      | L1                                   c
c               ~~~~~~~~\V1    |                                      c
c       p+q (incoming)    \    |                                      c
c                        L3 \  |                                      c
c                             \|_____________ l'  (j)                 c
c                              V2     q (outgoing)                    c
c                                                                     c
c       General form of the vertex (G(mu) = gamma(mu),                c
c       G(5)= gamma(5)):                                              c
c                                                                     c
c       V = V_tree                                                    c
c         + i(F_1 G(mu) - F_2 G(mu)G(5) + F_3 p(mu)                   c
c           - F_4 p(mu)G(5) + F_5 q(mu) - F_6 q(mu)G(5))              c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c      Other arguments:                                               c
c       form:      complex output array containing formfactor values  c
c                                                                     c
c      Only F_1, F_2 require renormalization.                         c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine zee_vert1(i,j,form)
c     Neutrino-neutrino-W in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      call vff_vert(zero,wm,zero,co,co,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) + e*e2/32/sct/st2*tmp(k)
      return
      end
 
      subroutine zee_vert2(i,j,form)
c     Lepton-lepton-photon in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/dimreg/idflag
      if (i.ne.j) return
c     This is more tricky: This diagram should be omitted, because it
c     combine together with the bremsstrahlung to yield a QED factor.
c     This factor is however calculated taking this diagram in DIMREG.
c     Therefore the difference between its value in DRED and DIMREG
c     should be included here.
c     Full diagram:
      a1 = cmplx(1 - 4*st2,zero)
c      call vff_vert(em(i),zero,em(i),a1,co,co,cz,co,cz,tmp)
c      do 10 k=1,6
c10      form(k) = form(k) - e*e2/4/sct*tmp(k)
c     DRED-DIMREG difference:
      if (idflag.eq.1) return
      form(1) = form(1) + e2*e/4/sct*a1
      form(2) = form(2) + e2*e/4/sct
      return
      end
 
      subroutine zee_vert3(i,j,form)
c     Lepton-lepton-Z0 in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),a1
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      a1 = cmplx(1 - 4*st2,zero)
      call vff_vert(em(i),zm,em(i),a1,co,a1,co,a1,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) - e*e2/64/sct/sct2*tmp(k)
      return
      end
 
      subroutine zee_vert4(i,j,form)
c     W-W-neutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      if (i.ne.j) return
      call fww_vert(wm,zero,wm,co,co,co,co,tmp)
      do 10 k=1,6
10      form(k) = form(k) + e*e2*ct/8/st/st2*tmp(k)
      return
      end
 
      subroutine zee_vert56(i,j,form)
c     Charged Goldstone-W-neutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      call fsv_vert(wm,zero,wm,co,co,co,-co,tmp1)
      call fvs_vert(wm,zero,wm,co,co,co,co,tmp2)
      do 10 k=1,6
10      form(k) = form(k) - e*e2*em(i)/8/sct*(tmp1(k) + tmp2(k))
      return
      end
 
      subroutine zee_vert78(i,j,form)
c     Scalar-Z0-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2,zero)
      do 10 l=1,2
        call fsv_vert(rm(l),em(i),zm,vv,co,co,cz,tmp1)
        call fvs_vert(zm,em(i),rm(l),co,cz,vv,co,tmp2)
        do 10 k=1,6
          tmp1(k) = tmp1(k) + tmp2(k)
10        form(k) = form(k) -(e/2/sct)**3*em(i)*cr(l)*zr(1,l)/v1*tmp1(k)
      return
      end
 
      subroutine zee_vert9(i,j,form)
c     Charged Higgs-neutrino-neutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      do 10 l=1,2
        call sff_vert(zero,cm(l),zero,co,co,co,co,co,-co,tmp)
        do 10 k=1,6
10        form(k) = form(k) + e/8/sct*(em(i)*zh(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zee_vert10(i,j,form)
c     Scalar-lepton-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2,zero)
      do 10 l=1,2
        call sff_vert(em(i),rm(l),em(i),vv,co,co,cz,co,cz,tmp)
        do 10 k=1,6
10        form(k) = form(k) - e/4/sct*(em(i)*zr(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zee_vert11(i,j,form)
c     Pseudoscalar-lepton-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6),vv
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      vv = cmplx(1 - 4*st2,zero)
      do 10 l=1,2
        call sff_vert(em(i),pm(l),em(i),vv,co,cz,co,cz,co,tmp)
        do 10 k=1,6
10        form(k) = form(k) + e/4/sct*(em(i)*zh(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zee_vert12(i,j,form)
c     Slepton-neutralino-neutralino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 a1,a2,a3,b1,b2,b3
      complex*16 vl_nnz,vr_nnz,vl_lln,vr_lln
      complex*16 zv,zl,zn
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/neut/fnm(4),zn(4,4)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,4
        do 10 m=1,4
          do 10 n=1,6
            a1 = vl_nnz(l,m) + vr_nnz(l,m)
            b1 = vl_nnz(l,m) - vr_nnz(l,m)
            a2 = conjg(vr_lln(j,n,l) + vl_lln(j,n,l))
            b2 = conjg(vr_lln(j,n,l) - vl_lln(j,n,l))
            a3 = vl_lln(i,n,m) + vr_lln(i,n,m)
            b3 = vl_lln(i,n,m) - vr_lln(i,n,m)
            call sff_vert(fnm(m),slm(n),fnm(l),a1,b1,a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) - e/8/sct*tmp(k)
      return
      end
 
      subroutine zee_vert13(i,j,form)
c     Sneutrino-chargino-chargino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 a1,a2,a3,b1,b2,b3
      complex*16 vl_ccz,vr_ccz,vl_lsnc,vr_lsnc
      complex*16 zv,zl,zpos,zneg
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,2
        do 10 m=1,2
          do 10 n=1,3
            a1 = - vr_ccz(m,l) - vl_ccz(m,l)
            b1 = - vr_ccz(m,l) + vl_ccz(m,l)
            a2 = conjg(vr_lsnc(j,n,l) + vl_lsnc(j,n,l))
            b2 = conjg(vr_lsnc(j,n,l) - vl_lsnc(j,n,l))
            a3 = vl_lsnc(i,n,m) + vr_lsnc(i,n,m)
            b3 = vl_lsnc(i,n,m) - vr_lsnc(i,n,m)
            call sff_vert(fcm(m),vm(n),fcm(l),a1,b1,a2,b2,a3,b3,tmp)
            do 10 k=1,6
10            form(k) = form(k) + e/16/sct*tmp(k)
      return
      end
 
      subroutine zee_vert14(i,j,form)
c     Charged Higgs-charged Higgs-neutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      do 10 l=1,2
        call fss_vert(cm(l),zero,cm(l),co,co,co,-co,tmp)
        do 10 k=1,6
10        form(k) = form(k)
     1            + e*(ct2 - st2)/4/sct*(em(i)*zh(1,l)/v1)**2*tmp(k)
      return
      end
 
      subroutine zee_vert156(i,j,form)
c     Scalar-pseudoscalar-lepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp1(6),tmp2(6),form(6)
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      if (i.ne.j) return
      do 10 l=1,2
        do 10 m=1,2
          call fss_vert(rm(l),em(i),pm(m),cz,co,co,cz,tmp1)
          call fss_vert(pm(m),em(i),rm(l),co,cz,cz,co,tmp2)
          do 10 k=1,6
10          form(k) = form(k) - e/2/sct*(em(i)/v1)**2
     1              *am(l,m)*zr(1,l)*zh(1,m)*(tmp1(k) - tmp2(k))
      return
      end
 
      subroutine zee_vert17(i,j,form)
c     Chargino-sneutrino-sneutrino in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 a2,a3,b2,b3
      complex*16 vl_lsnc,vr_lsnc
      complex*16 zv,zl,zpos,zneg
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,3
        do 10 m=1,2
          a3 = vl_lsnc(i,l,m) + vr_lsnc(i,l,m)
          b3 = vl_lsnc(i,l,m) - vr_lsnc(i,l,m)
          a2 = conjg(vr_lsnc(j,l,m) + vl_lsnc(j,l,m))
          b2 = conjg(vr_lsnc(j,l,m) - vl_lsnc(j,l,m))
          call fss_vert(vm(l),fcm(m),vm(l),a2,b2,a3,b3,tmp)
          do 10 k=1,6
10          form(k) = form(k) - e/8/sct*tmp(k)
      return
      end
 
      subroutine zee_vert18(i,j,form)
c     Neutralino-slepton-slepton in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp(6),form(6)
      complex*16 a2,a3,b2,b3
      complex*16 vl_lln,vr_lln,v_llz
      complex*16 zv,zl,zn
      complex*16 cz,co,ci
      common/num/cz,co,ci,zero,one
      common/vev/v1,v2
      common/fmass/em(3),um(3),dm(3)
      common/neut/fnm(4),zn(4,4)
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 l=1,6
        do 10 m=1,6
          do 10 n=1,4
          a3 = vl_lln(i,l,n) + vr_lln(i,l,n)
          b3 = vl_lln(i,l,n) - vr_lln(i,l,n)
          a2 = conjg(vr_lln(j,m,n) + vl_lln(j,m,n))
          b2 = conjg(vr_lln(j,m,n) - vl_lln(j,m,n))
          call fss_vert(slm(l),fnm(n),slm(m),a2,b2,a3,b3,tmp)
          do 10 k=1,6
10          form(k) = form(k) + e/8/sct*v_llz(l,m)*tmp(k)
      return
      end
 
      subroutine zee_vert(s,i,j,form)
c     Full bare Zll formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p,q,pq
      common/fmass/em(3),um(3),dm(3)
      common/parcont/if,is,ig,ic,in,iq,il
      do 10 k=1,6
10      form(k) = (0,0)
      p  = em(i)*em(i)
      q  = em(j)*em(j)
      pq = (s - p - q)/2
      if ((if.ne.ig).or.(is.ne.ic).or.(is.ne.in))
     1   stop 'if=ig and is=ic=in required in zee_vert!'
      if (if*ig.eq.1) then
        call zee_vert1(i,j,form)
        call zee_vert2(i,j,form)
        call zee_vert3(i,j,form)
        call zee_vert4(i,j,form)
        call zee_vert56(i,j,form)
        call zee_vert78(i,j,form)
        call zee_vert9(i,j,form)
        call zee_vert10(i,j,form)
        call zee_vert11(i,j,form)
        call zee_vert14(i,j,form)
        call zee_vert156(i,j,form)
      end if
      if (is*in*ic.eq.1) then
        call zee_vert12(i,j,form)
        call zee_vert13(i,j,form)
        call zee_vert17(i,j,form)
        call zee_vert18(i,j,form)
      end if
      do 20 k=1,6
20      form(k) = form(k)/16/pi/pi
      return
      end
 
      subroutine zee_ren(s,i,j,form)
c     Full renormalized Zll formfactors
      implicit double precision (a-h,o-z)
      complex*16 form(6),tmp(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/frconst/dzll(3),dzre(3),dzlq(3),dzru(3),dzrd(3)
      form(1) = e/4/sct*(1 - 4*st2)
      form(2) = e/4/sct
      do 10 k=3,6
10       form(k) = (0,0)
      if (.not.fstat) return
      call zee_vert(s,i,j,tmp)
      do 20 k=1,6
20      form(k) = form(k) + tmp(k)
      form(1) = form(1) + e/4/sct*((1 - 2*st2)*dzll(i)
     1                  - 2*st2*dzre(i) + ct2*(dz2 - dza))
      form(2) = form(2) + e/4/sct*((1 - 2*st2)*dzll(i)
     1                  + 2*st2*dzre(i) + ct2*(dz2 - dza))
      return
      end
 
 
 
