c     PROGRAMS FOR ONE-LOOP ON-SHELL CALCULATIONS IN THE MSSM
c     Authors: P.H.Chankowski, S.Pokorski, J.Rosiek
c     e-mail: rosiek@fuw.edu.pl
c             chank@padova.infn.it
 
c     FILENAME: ZZS_VERT.FOR
c     Last revised: 16: 4:1996(J.R.)
c     Long lines in chargino/neutralino contributions splitted
 
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     This file contains Z0-Z0-scalar vertex formfactors              c
c     and their renormalization.                                      c
c                                                                     c
c     Incoming Z0:          momentum (p+q)(\mu)                       c
c     Outgoing Z0:          momentum  p(\nu)                          c
c     Outgoing scalar S(i): momentum  q    (S_i = H^0_i)              c
c                                                                     c
c                                                                     c
c                                        Z^0_{\nu}                    c
c                             /|~~~~~~~                               c
c                           /  |      p (outgoing)                    c
c                         /    |                                      c
c        Z^0_{\mu}      /      |                                      c
c               ~~~~~~~~\      |                                      c
c       p+q (incoming)    \    |                                      c
c                           \  |                                      c
c                             \|_ _ _ _  S_i                          c
c                                     q (outgoing)                    c
c                                                                     c
c       General form of the vertex: (compare: Chankowski,             c
c       Pokorski,Rosiek@Nucl.Phys.B423 (1994), 437 available as       c
c       hep-ph-9303309:                                               c
c                                                                     c
c       V = V_tree                                                    c
c         + i(F_1 g(mu,nu) + F_2 p(mu)p(nu) + F_3 q(mu)q(nu)          c
c                          + F_4 p(mu)q(nu) + F_5 q(mu)p(nu))         c
c                          + F_6 eps(p,q,mu,nu)                       c
c                                                                     c
c      Momentum arguments in formfactors:                             c
c      p = p^2    q = q^2    pq = 1/2 ((p + q)^2 - p^2 - q^2)         c
c                                                                     c
c      Only F_1 requires renormalization.                             c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
 
      subroutine zzs_3vert1(p,q,pq,i,form)
c     3 fermions in loop
      implicit double precision (a-h,o-z)
      complex*16 tmp,form(6)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/fmass/em(3),um(3),dm(3)
      common/vev/v1,v2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,3
        v = 1 - 4*st2
        tmp = - 2*(p + em(k)*em(k))*(1 - v*v)*c0(em(k),em(k),em(k))
     1        - 16*c24(em(k),em(k),em(k)) - 8*p*c11(em(k),em(k),em(k))
     2        - 6*p*c21(em(k),em(k),em(k))
     3        - 2*p*v*v*c21(em(k),em(k),em(k))
     4        - 4*q*c12(em(k),em(k),em(k)) - 6*q*c22(em(k),em(k),em(k))
     5        - 2*q*v*v*c22(em(k),em(k),em(k))
     6        - 2*pq*(c0(em(k),em(k),em(k)) + 2*c11(em(k),em(k),em(k))
     7        + 4*c12(em(k),em(k),em(k)) + 6*c23(em(k),em(k),em(k)))
     8        + 2*v*v*pq*(c0(em(k),em(k),em(k))
     9        - 2*c23(em(k),em(k),em(k))) - 3 - v*v
        form(1) = form(1) - e2/sct2/4*em(k)*em(k)/v1*zr(1,i)*tmp
        form(2) = form(2) - 2*e2/sct2*em(k)*em(k)/v1*zr(1,i)
     1          *(1 + v*v)*(c11(em(k),em(k),em(k))
     2          + c21(em(k),em(k),em(k)))
        form(3) = form(3) - e2/sct2*em(k)*em(k)/v1*zr(1,i)*(1 + v*v)
     1          *(c12(em(k),em(k),em(k)) + 2*c22(em(k),em(k),em(k)))
        form(4) = form(4) - e2/sct2*em(k)*em(k)/v1*zr(1,i)
     1          *((1 - v*v)/2*c0(em(k),em(k),em(k))
     2          + c11(em(k),em(k),em(k))
     3          + (1 + v*v)*c12(em(k),em(k),em(k))
     4          + 2*(1 + v*v)*c23(em(k),em(k),em(k)))    
        form(5) = form(5) - e2/sct2*em(k)*em(k)/v1*zr(1,i)
     1          *(2*(1 + v*v)*c23(em(k),em(k),em(k))
     2          - (1 - v*v)/2*c0(em(k),em(k),em(k))
     3          + (1 + v*v)*c12(em(k),em(k),em(k))
     4          + v*v*c11(em(k),em(k),em(k)))
        call creset
        v = 1 - 8.d0/3*st2
        tmp = - 2*(p + um(k)*um(k))*(1 - v*v)*c0(um(k),um(k),um(k))
     1        - 16*c24(um(k),um(k),um(k)) - 8*p*c11(um(k),um(k),um(k))
     2        - 6*p*c21(um(k),um(k),um(k))
     3        - 2*p*v*v*c21(um(k),um(k),um(k))
     4        - 4*q*c12(um(k),um(k),um(k)) - 6*q*c22(um(k),um(k),um(k))
     5        - 2*q*v*v*c22(um(k),um(k),um(k))
     6        - 2*pq*(c0(um(k),um(k),um(k)) + 2*c11(um(k),um(k),um(k))
     7        + 4*c12(um(k),um(k),um(k)) + 6*c23(um(k),um(k),um(k)))
     8        + 2*v*v*pq*(c0(um(k),um(k),um(k))
     9        - 2*c23(um(k),um(k),um(k))) - 3 - v*v
        form(1) = form(1) - 0.75d0*e2/sct2*um(k)*um(k)/v2*zr(2,i)*tmp
        form(2) = form(2) - 6*e2/sct2*um(k)*um(k)/v2*zr(2,i)
     1          *(1 + v*v)*(c11(um(k),um(k),um(k))
     2          + c21(um(k),um(k),um(k)))
        form(3) = form(3) - 3*e2/sct2*um(k)*um(k)/v2*zr(2,i)*(1 + v*v)
     1          *(c12(um(k),um(k),um(k)) + 2*c22(um(k),um(k),um(k)))
        form(4) = form(4) - 3*e2/sct2*um(k)*um(k)/v2*zr(2,i)
     1          *((1 - v*v)/2*c0(um(k),um(k),um(k))
     2          + c11(um(k),um(k),um(k))
     3          + (1 + v*v)*c12(um(k),um(k),um(k))
     4          + 2*(1 + v*v)*c23(um(k),um(k),um(k)))  
        form(5) = form(5) - 3*e2/sct2*um(k)*um(k)/v2*zr(2,i)
     1          *(2*(1 + v*v)*c23(um(k),um(k),um(k))
     2          - (1 - v*v)/2*c0(um(k),um(k),um(k))
     3          + (1 + v*v)*c12(um(k),um(k),um(k))
     4          + v*v*c11(um(k),um(k),um(k)))
        call creset
        v = 1 - 4.d0/3*st2
        tmp = - 2*(p + dm(k)*dm(k))*(1 - v*v)*c0(dm(k),dm(k),dm(k))
     1        - 16*c24(dm(k),dm(k),dm(k)) - 8*p*c11(dm(k),dm(k),dm(k))
     2        - 6*p*c21(dm(k),dm(k),dm(k))
     3        - 2*p*v*v*c21(dm(k),dm(k),dm(k))
     4        - 4*q*c12(dm(k),dm(k),dm(k)) - 6*q*c22(dm(k),dm(k),dm(k))
     5        - 2*q*v*v*c22(dm(k),dm(k),dm(k))
     6        - 2*pq*(c0(dm(k),dm(k),dm(k)) + 2*c11(dm(k),dm(k),dm(k))
     7        + 4*c12(dm(k),dm(k),dm(k)) + 6*c23(dm(k),dm(k),dm(k)))
     8        + 2*v*v*pq*(c0(dm(k),dm(k),dm(k))
     9        - 2*c23(dm(k),dm(k),dm(k))) - 3 - v*v        
        form(1) = form(1) - 0.75d0*e2/sct2*dm(k)*dm(k)/v1*zr(1,i)*tmp
        form(2) = form(2) - 6*e2/sct2*dm(k)*dm(k)/v1*zr(1,i)
     1          *(1 + v*v)*(c11(dm(k),dm(k),dm(k))
     2          + c21(dm(k),dm(k),dm(k)))
        form(3) = form(3) - 3*e2/sct2*dm(k)*dm(k)/v1*zr(1,i)*(1 + v*v)
     1          *(c12(dm(k),dm(k),dm(k)) + 2*c22(dm(k),dm(k),dm(k)))
        form(4) = form(4) - 3*e2/sct2*dm(k)*dm(k)/v1*zr(1,i)
     1          *((1 - v*v)/2*c0(dm(k),dm(k),dm(k)) 
     2          + c11(dm(k),dm(k),dm(k)) 
     3          + (1 + v*v)*c12(dm(k),dm(k),dm(k))
     4          + 2*(1 + v*v)*c23(dm(k),dm(k),dm(k)))
        form(5) = form(5) - 3*e2/sct2*dm(k)*dm(k)/v1*zr(1,i)
     1          *(2*(1 + v*v)*c23(dm(k),dm(k),dm(k))
     2          - (1 - v*v)/2*c0(dm(k),dm(k),dm(k))
     3          + (1 + v*v)*c12(dm(k),dm(k),dm(k))
     4          + v*v*c11(dm(k),dm(k),dm(k)))  
10      call creset
      return
      end
 
      subroutine zzs_3vert2(p,q,pq,i,form)
c     3 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      complex*16 v_llz,v_uuz,v_ddz
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      common/sf_acc/epsf
      do 10 k=1,3
        form(1) = form(1) + (e/sct)**4/2*br(i)*c24(vm(k),vm(k),vm(k))
        form(2) = form(2) + (e/sct)**4/2*br(i)*(c0(vm(k),vm(k),vm(k))/4
     1          + c11(vm(k),vm(k),vm(k)) + c21(vm(k),vm(k),vm(k)))
        form(3) = form(3) + (e/sct)**4/4*br(i)*(c12(vm(k),vm(k),vm(k)) 
     1          + 2*c22(vm(k),vm(k),vm(k)))
        form(4) = form(4) + (e/sct)**4/4*br(i)
     1          *(c12(vm(k),vm(k),vm(k)) + 2*c23(vm(k),vm(k),vm(k)))
        form(5) = form(5) + (e/sct/2)**4*br(i)
     1          *(c0(vm(k),vm(k),vm(k))/2 + c11(vm(k),vm(k),vm(k))
     2          + c12(vm(k),vm(k),vm(k)) + 2*c23(vm(k),vm(k),vm(k)))
 10     call creset
      do 20 k=1,6
        do 20 l=1,6
          do 20 m=1,6
            tmp = 2*e2/sct2*dble(v_llz(l,k)*v_llz(k,m)*v_lls(m,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(slm(k),slm(m),slm(l))
              form(2) = form(2) - tmp*(c11(slm(k),slm(m),slm(l))
     1                + c0(slm(k),slm(m),slm(l))/4
     2                + c21(slm(k),slm(m),slm(l)))
              form(3) = form(3) - tmp*(c12(slm(k),slm(m),slm(l))/2
     1                + c22(slm(k),slm(m),slm(l)))
              form(4) = form(4) - tmp*(c12(slm(k),slm(m),slm(l))/2
     1                + c23(slm(k),slm(m),slm(l)))
              form(5) = form(5) - tmp/4*(2*c11(slm(k),slm(m),slm(l))
     1                + c0(slm(k),slm(m),slm(l))
     2                + 2*c12(slm(k),slm(m),slm(l))
     3                + 4*c23(slm(k),slm(m),slm(l)))
              call creset
            end if
            tmp = 6*e2/sct2*dble(v_uuz(l,k)*v_uuz(k,m)*v_uus(m,l,i))
            if (abs(tmp).gt.epsf) then
              form(1) = form(1) - tmp*c24(sum(k),sum(m),sum(l))
              form(2) = form(2) - tmp*(c11(sum(k),sum(m),sum(l))
     1                + c0(sum(k),sum(m),sum(l))/4
     2                + c21(sum(k),sum(m),sum(l)))
              form(3) = form(3) - tmp*(c12(sum(k),sum(m),sum(l))/2
     1                + c22(sum(k),sum(m),sum(l)))
              form(4) = form(4) - tmp*(c12(sum(k),sum(m),sum(l))/2
     1                + c23(sum(k),sum(m),sum(l))) 
              form(5) = form(5) - tmp/4*(2*c11(sum(k),sum(m),sum(l))
     1                + c0(sum(k),sum(m),sum(l))
     2                + 2*c12(sum(k),sum(m),sum(l))
     3                + 4*c23(sum(k),sum(m),sum(l)))
              call creset
            end if
            tmp = 6*e2/sct2*dble(v_ddz(l,k)*v_ddz(k,m)*v_dds(m,l,i))
            if (abs(tmp).gt.epsf) then              
              form(1) = form(1) - tmp*c24(sdm(k),sdm(m),sdm(l))             
              form(2) = form(2) - tmp*(c11(sdm(k),sdm(m),sdm(l))
     1                + c0(sdm(k),sdm(m),sdm(l))/4
     2                + c21(sdm(k),sdm(m),sdm(l)))
              form(3) = form(3) - tmp*(c12(sdm(k),sdm(m),sdm(l))/2
     1                + c22(sdm(k),sdm(m),sdm(l)))
              form(4) = form(4) - tmp*(c12(sdm(k),sdm(m),sdm(l))/2
     1                    + c23(sdm(k),sdm(m),sdm(l)))
              form(5) = form(5) - tmp/4*(2*c11(sdm(k),sdm(m),sdm(l))
     1                + c0(sdm(k),sdm(m),sdm(l))
     2                + 2*c12(sdm(k),sdm(m),sdm(l))
     3                + 4*c23(sdm(k),sdm(m),sdm(l)))
              call creset
            end if
20    continue
      return
      end
 
      subroutine zzs_3vert3(p,q,pq,i,form)
c     Z0 + scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          form(1) = form(1) + (e/sct)**4/4*am(k,l)*am(i,l)
     1            *cr(k)*c24(rm(k),zm,pm(l))
          form(2) = form(2) + (e/sct)**4/8*am(k,l)*am(i,l)
     1            *cr(k)*(c0(rm(k),zm,pm(l)) + 3*c11(rm(k),zm,pm(l)) 
     2            + 2*c21(rm(k),zm,pm(l)))
          form(3) = form(3) + (e/sct)**4/8*am(k,l)*am(i,l)
     1            *cr(k)*(2*c0(rm(k),zm,pm(l)) + 5*c12(rm(k),zm,pm(l)) 
     2            + 2*c22(rm(k),zm,pm(l)))
          form(4) = form(4) + (e/sct)**4/8*am(k,l)*am(i,l)
     1            *cr(k)*(2*c0(rm(k),zm,pm(l)) + c12(rm(k),zm,pm(l))
     2            + 4*c11(rm(k),zm,pm(l)) + 2*c23(rm(k),zm,pm(l)))
          form(5) = form(5) + (e/sct)**4/8*am(k,l)*am(i,l)
     1            *cr(k)*(c0(rm(k),zm,pm(l)) + c11(rm(k),zm,pm(l))
     2            + 2*c12(rm(k),zm,pm(l)) + 2*c23(rm(k),zm,pm(l)))
10        call creset
      return
      end
 
      subroutine zzs_3vert4(p,q,pq,i,form)
c     2 scalars + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          do 10 j=1,2
            form(1) = form(1) + (e/sct)**4/4*am(k,j)*am(l,j)
     1              *v_sss(i,k,l)*c24(pm(j),rm(l),rm(k))
            form(2) = form(2) + (e/sct)**4/4*am(k,j)*am(l,j)
     1              *v_sss(i,k,l)*(c0(pm(j),rm(l),rm(k))/4
     2              + c11(pm(j),rm(l),rm(k)) + c21(pm(j),rm(l),rm(k)))
            form(3) = form(3) + (e/sct)**4/8*am(k,j)*am(l,j)
     1              *v_sss(i,k,l)*(c12(pm(j),rm(l),rm(k))
     2              + 2*c22(pm(j),rm(l),rm(k)))
            form(4) = form(4) + (e/sct)**4/4*am(k,j)*am(l,j)
     1              *v_sss(i,k,l)*(c12(pm(j),rm(l),rm(k))/2
     2              + c23(pm(j),rm(l),rm(k)))
            form(5) = form(5) + 2*(e/sct/2)**4*am(k,j)*am(l,j)
     1              *v_sss(i,k,l)*(c0(pm(j),rm(l),rm(k))/2
     2              + c11(pm(j),rm(l),rm(k)) + c12(pm(j),rm(l),rm(k))
     4              + 2*c23(pm(j),rm(l),rm(k)))
10          call creset
      return
      end
 
      subroutine zzs_3vert5(p,q,pq,i,form)
c     Scalar + 2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 l=1,2
          do 10 j=1,2
            form(1) = form(1) + (e/sct)**4/4*am(j,k)*am(j,l)
     1              *ah(k,l)*br(i)*c24(rm(j),pm(l),pm(k))
            form(2) = form(2) + (e/sct)**4/4*am(j,k)*am(j,l)
     1              *ah(k,l)*br(i)*(c0(rm(j),pm(l),pm(k))/4
     2              + c11(rm(j),pm(l),pm(k)) + c21(rm(j),pm(l),pm(k)))
            form(3) = form(3) + (e/sct)**4/8*am(j,k)*am(j,l)
     1              *ah(k,l)*br(i)*(c12(rm(j),pm(l),pm(k))
     2              + 2*c22(rm(j),pm(l),pm(k)))
            form(4) = form(4) + (e/sct)**4/4*am(j,k)*am(j,l)
     1              *ah(k,l)*br(i)*(c12(rm(j),pm(l),pm(k))/2
     2              + c23(rm(j),pm(l),pm(k)))
            form(5) = form(5) + 2*(e/sct/2)**4*am(j,k)*am(j,l)*ah(k,l)
     1              *br(i)*(c0(rm(j),pm(l),pm(k))/2
     2              + c11(rm(j),pm(l),pm(k)) + c12(rm(j),pm(l),pm(k))
     3              + 2*c23(rm(j),pm(l),pm(k)))
10          call creset
      return
      end
 
      subroutine zzs_3vert6(p,q,pq,i,form)
c     3 charged Higgses in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
        form(1) = form(1) + e*e2*(ct2 - st2)**2/sct2/st
     1          *v_hhs(i,j,j)*c24(cm(j),cm(j),cm(j))
        form(2) = form(2) + e*e2*(ct2 - st2)**2/sct2/st
     1          *v_hhs(i,j,j)*(c0(cm(j),cm(j),cm(j))/4
     2          + c11(cm(j),cm(j),cm(j)) + c21(cm(j),cm(j),cm(j)))
        form(3) = form(3) + e*e2*(ct2 - st2)**2/sct2/st/2*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j)) + 2*c22(cm(j),cm(j),cm(j)))
        form(4) = form(4) + e*e2*(ct2 - st2)**2/sct2/st*v_hhs(i,j,j)
     1          *(c12(cm(j),cm(j),cm(j))/2 + c23(cm(j),cm(j),cm(j)))
        form(5) = form(5) + e*e2*(ct2 - st2)**2/sct2/st/4*v_hhs(i,j,j)
     1          *(c0(cm(j),cm(j),cm(j)) + 2*c11(cm(j),cm(j),cm(j))
     2          + 2*c12(cm(j),cm(j),cm(j)) + 4*c23(cm(j),cm(j),cm(j)))
10      call creset
      return
      end
 
      subroutine zzs_3vert79(p,q,pq,i,form)
c     2 charged Higgs + W in loop - Higgs pair coupled to Z0
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + 2*e*e2*zm*(ct2 - st2)/sct*am(i,2)
     1        *c24(wm,wm,wm)
      form(2) = form(2) + e*e2*zm*(ct2 - st2)/sct*am(i,2)*(c0(wm,wm,wm) 
     1        + 3*c11(wm,wm,wm) + 2*c21(wm,wm,wm))
      form(3) = form(3) + e*e2*zm*(ct2 - st2)/sct/2*am(i,2)
     1        *(2*c0(wm,wm,wm) + 3*c12(wm,wm,wm) + 4*c22(wm,wm,wm))
      form(4) = form(4) + e*e2*zm*(ct2 - st2)/sct*am(i,2)*(c0(wm,wm,wm)
     1        + 2*c11(wm,wm,wm) + 1.5d0*c12(wm,wm,wm) + 2*c23(wm,wm,wm))
      form(5) = form(5) + e*e2*zm*(ct2 - st2)/sct/2*am(i,2)
     1        *(3*c12(wm,wm,wm) + 4*c23(wm,wm,wm) - c11(wm,wm,wm))
      call creset
      return
      end
 
      subroutine zzs_3vert8(p,q,pq,i,form)
c     2 charged Higgs + W in loop - Higgs pair coupled to scalar
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/hm_phys/frm(2),frm2(2)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
c     Useful identity:
c     ah(2,2)*br(i)/cr(i) = rm(i)*rm(i)/zm2
      form(1) = form(1) - e*e2*st/ct2*v_hhs(i,2,2)*wm2*c0(wm,wm,wm)
      call creset
      return
      end
 
      subroutine zzs_3vert10(p,q,pq,i,form)
c     Charged Goldstone + 2 W in loop - W pair coupled to incoming Z0
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) + e*e2*zm*ct/st*am(i,2)*(2*pq*c11(wm,wm,wm)
     1        + (p - q)*c0(wm,wm,wm) - p*c21(wm,wm,wm) 
     2        + 2*q*c12(wm,wm,wm) - 2*pq*c23(wm,wm,wm) 
     3        - 3*c24(wm,wm,wm) - q*c22(wm,wm,wm) - 0.5d0)
      form(2) = form(2) + e*e2*zm*ct/st*am(i,2)*(c21(wm,wm,wm) 
     1        - c0(wm,wm,wm))
      form(3) = form(3) + e*e2*zm*ct/st*am(i,2)*(c0(wm,wm,wm) 
     1        + c22(wm,wm,wm) - 2*c12(wm,wm,wm))
      form(4) = form(4) + e*e2*zm*ct/st*am(i,2)*(c23(wm,wm,wm)
     1        - 3*c0(wm,wm,wm) - 4*c11(wm,wm,wm))
      form(5) = form(5) + e*e2*zm*ct/st*am(i,2)*(3*c0(wm,wm,wm)
     1        + 2*c11(wm,wm,wm) + c23(wm,wm,wm))
      call creset
      return
      end
 
      subroutine zzs_3vert11(p,q,pq,i,form)
c     Charged Goldstone + 2 W in loop - W pair coupled to outgoing Z0
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) + e*e2*zm*ct/st*am(i,2)*((p + 2*pq)*c0(wm,wm,wm)
     1        - 0.5d0 - p*c21(wm,wm,wm) - 2*q*c12(wm,wm,wm) 
     2        - q*c22(wm,wm,wm) - 2*pq*(c11(wm,wm,wm) + c23(wm,wm,wm)) 
     3        - 3*c24(wm,wm,wm))
      form(2) = form(2) + e*e2*zm*ct/st*am(i,2)*(c21(wm,wm,wm) 
     1        - c0(wm,wm,wm))
      form(3) = form(3) + e*e2*zm*ct/st*am(i,2)*(2*c12(wm,wm,wm)
     1        + c22(wm,wm,wm))
      form(4) = form(4) + e*e2*zm*ct/st*am(i,2)*(c23(wm,wm,wm)
     1        - 4*c0(wm,wm,wm) - 2*c11(wm,wm,wm))
      form(5) = form(5) + e*e2*zm*ct/st*am(i,2)*(2*c0(wm,wm,wm)
     1        + 4*c11(wm,wm,wm) + c23(wm,wm,wm))
      call creset
      return
      end
 
      subroutine zzs_3vert12(p,q,pq,i,form)
c     Charged Goldstone + 2 W in loop - W pair coupled to scalar
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) - e2*e2*zm2*cr(i)*c0(wm,wm,wm)
      call creset
      return
      end
 
      subroutine zzs_3vert13(p,q,pq,i,form)
c     2 Z0 + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        form(1) = form(1) - (e/sct)**6/8*cr(k)**2*cr(i)*c0(rm(k),zm,zm)
10      call creset
      return
      end
 
      subroutine zzs_3vert14(p,q,pq,i,form)
c     Z0 + 2 scalars in loop
      implicit double precision (a-h,o-z)
      complex*16 c0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 j=1,2
          form(1) = form(1) - (e/sct)**6/16*cr(k)*cr(j)
     1            *v_sss(i,j,k)*c0(zm,rm(k),rm(j))
10        call creset
      return
      end
 
      subroutine zzs_3vert15(p,q,pq,i,form)
c     Z0 + scalar + pseudoscalar in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 k=1,2
        do 10 j=1,2
          form(1) = form(1) + (e/sct)**4/4*cr(j)*am(j,k)*am(i,k)
     1            *c24(rm(j),pm(k),zm)
          form(2) = form(2) + (e/sct)**4/8*cr(j)*am(j,k)*am(i,k)
     1            *(c0(rm(j),pm(k),zm) + 3*c11(rm(j),pm(k),zm) 
     2            + 2*c21(rm(j),pm(k),zm))
          form(3) = form(3) + (e/sct)**4/4*cr(j)*am(j,k)*am(i,k)
     1            *(c22(rm(j),pm(k),zm) - c12(rm(j),pm(k),zm))
          form(4) = form(4) + (e/sct)**4/4*cr(j)*am(j,k)*am(i,k)
     1            *(c12(rm(j),pm(k),zm) + c23(rm(j),pm(k),zm))
          form(5) = form(5) + (e/sct)**4/8*cr(j)*am(j,k)*am(i,k)
     1            *(c12(rm(j),pm(k),zm) - c0(rm(j),pm(k),zm) 
     2            - 2*c11(rm(j),pm(k),zm) + 2*c23(rm(j),pm(k),zm))
10        call creset
      return
      end
 
      subroutine zzs_3vert16(p,q,pq,i,form)
c     3 W in loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) + (e/st)**4*ct2*cr(i)*(5*(p + pq)*c0(wm,wm,wm)
     1        + (2*p + pq)*c11(wm,wm,wm) + 2*p*c21(wm,wm,wm) + 1
     2        + (q + 2*pq)*c12(wm,wm,wm) + 2*q*c22(wm,wm,wm)
     3        + 4*pq*c23(wm,wm,wm) + 18*c24(wm,wm,wm))
      form(2) = form(2) + 2*(e/st)**4*ct2*cr(i)*(5*c21(wm,wm,wm) 
     1        + 5*c11(wm,wm,wm) - c0(wm,wm,wm))
      form(3) = form(3) + 5*(e/st)**4*ct2*cr(i)*(c12(wm,wm,wm)
     1        + 2*c22(wm,wm,wm))
      form(4) = form(4) + (e/st)**4*ct2*cr(i)*(c11(wm,wm,wm) 
     1        - 4*c0(wm,wm,wm) + 5*c12(wm,wm,wm) + 10*c23(wm,wm,wm))
      form(5) = form(5) + (e/st)**4*ct2*cr(i)*(2*c0(wm,wm,wm)
     1         + 4*c11(wm,wm,wm) + 5*c12(wm,wm,wm) + 10*c23(wm,wm,wm))
      call creset
      return
      end
 
      subroutine zzs_3vert17(p,q,pq,i,form)
c     3 W-ghosts in loop
      implicit double precision (a-h,o-z)
      complex*16 c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) - (e/st)**4*ct2*cr(i)*c24(wm,wm,wm)
      form(2) = form(2) - (e/st)**4*ct2*cr(i)*(c11(wm,wm,wm) 
     1        + c21(wm,wm,wm))
      form(3) = form(3) - (e/st)**4*ct2*cr(i)/2*(c12(wm,wm,wm)
     1        + 2*c22(wm,wm,wm))
      form(4) = form(4) - (e/st)**4*ct2*cr(i)*(c12(wm,wm,wm)/2
     1        + c23(wm,wm,wm))
      form(5) = form(5) - (e/st)**4*ct2*cr(i)/2*(c11(wm,wm,wm)
     1        + c12(wm,wm,wm) + 2*c23(wm,wm,wm))
      call creset
      return
      end
 
      subroutine zzs_3vert18(p,q,pq,i,form)
c     3 charginos loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      complex*16 zpos,zneg
      complex*16 vl_ccz,vr_ccz,v_ccs
      complex*16 a,b,c,x,y,z
      common/charg/fcm(2),zpos(2,2),zneg(2,2)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,2
        do 10 l=1,2
          do 10 m=1,2
            a = vr_ccz(l,k) + vl_ccz(l,k)
            x = vr_ccz(l,k) - vl_ccz(l,k)
            b = vr_ccz(k,m) + vl_ccz(k,m)
            y = vr_ccz(k,m) - vl_ccz(k,m)
            c = conjg(v_ccs(m,l,i)) + v_ccs(l,m,i)
            z = conjg(v_ccs(m,l,i)) - v_ccs(l,m,i)
            form(1) = form(1) - e*e2*sq2/st/sct2/8
     1              *(fcm(k)*fcm(l)*fcm(m)*dble(a*b*c - x*y*c
     2              - x*b*z + a*y*z)*c0(fcm(k),fcm(m),fcm(l))
     3              + fcm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     4              *((p + pq)*c0(fcm(k),fcm(m),fcm(l)) + 0.5d0
     5              + (2*p + pq)*c11(fcm(k),fcm(m),fcm(l))
     6              + (q + 2*pq)*c12(fcm(k),fcm(m),fcm(l))
     7              + p*c21(fcm(k),fcm(m),fcm(l))
     8              + q*c22(fcm(k),fcm(m),fcm(l))
     9              + 2*pq*c23(fcm(k),fcm(m),fcm(l))
     a              + 4*c24(fcm(k),fcm(m),fcm(l)))
     b              - fcm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     c              *(p*c11(fcm(k),fcm(m),fcm(l)) + 0.5d0
     d              + pq*c12(fcm(k),fcm(m),fcm(l))
     e              + p*c21(fcm(k),fcm(m),fcm(l))
     f              + q*c22(fcm(k),fcm(m),fcm(l))
     g              + 2*pq*c23(fcm(k),fcm(m),fcm(l))
     h              + 2*c24(fcm(k),fcm(m),fcm(l))))
            form(1) = form(1) + e*e2*sq2/st/sct2/8
     1              *fcm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     2              *((p + pq)*c11(fcm(k),fcm(m),fcm(l)) + 0.5d0
     3              + (q + pq)*c12(fcm(k),fcm(m),fcm(l))
     4              + p*c21(fcm(k),fcm(m),fcm(l))
     5              + q*c22(fcm(k),fcm(m),fcm(l))
     6              + 2*pq*c23(fcm(k),fcm(m),fcm(l))
     7              + 2*c24(fcm(k),fcm(m),fcm(l)))
            form(2) = form(2) - e*e2*sq2/st/sct2/4
     1              *(fcm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     2              + fcm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z))
     3              *(c11(fcm(k),fcm(m),fcm(l)) 
     4              + c21(fcm(k),fcm(m),fcm(l)))
            form(3) = form(3) - e*e2*sq2/st/sct2/4
     1              *(fcm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     2              *c22(fcm(k),fcm(m),fcm(l))
     3              + fcm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     4              * (c12(fcm(k),fcm(m),fcm(l))
     5              + c22(fcm(k),fcm(m),fcm(l))))
            form(4) = form(4) - e*e2*sq2/st/sct2/8
     1              *(- fcm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2              *(c0(fcm(k),fcm(m),fcm(l)) 
     3              + c11(fcm(k),fcm(m),fcm(l)))
     4              + fcm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     5              *(c12(fcm(k),fcm(m),fcm(l))
     6              + 2*c23(fcm(k),fcm(m),fcm(l)))
     7              + fcm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8              *(c11(fcm(k),fcm(m),fcm(l)) 
     9              + c12(fcm(k),fcm(m),fcm(l))
     a              + 2*c23(fcm(k),fcm(m),fcm(l))))
            form(5) = form(5) - e*e2*sq2/st/sct2/8
     1              *(fcm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2              *(c0(fcm(k),fcm(m),fcm(l))
     3              + c11(fcm(k),fcm(m),fcm(l)))
     4              + fcm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     5              *(c12(fcm(k),fcm(m),fcm(l))
     6              + 2*c23(fcm(k),fcm(m),fcm(l)))
     7              + fcm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8              *(c11(fcm(k),fcm(m),fcm(l)) 
     9              + c12(fcm(k),fcm(m),fcm(l))
     a              + 2*c23(fcm(k),fcm(m),fcm(l))))
            form(6) = form(6) - e*e2*sq2/st/sct2/8
     1              *(fcm(k)*dimag(x*y*z - x*b*c + a*y*c - a*b*z)
     2              *(c0(fcm(k),fcm(m),fcm(l)) 
     3              + c11(fcm(k),fcm(m),fcm(l)))
     4              + fcm(l)*dimag(x*y*z - x*b*c - a*y*c + a*b*z)
     5              *c12(fcm(k),fcm(m),fcm(l))
     6              + fcm(m)*dimag(x*y*z + x*b*c + a*y*c + a*b*z)
     7              *(c11(fcm(k),fcm(m),fcm(l))
     8              - c12(fcm(k),fcm(m),fcm(l))))
10          call creset
      return
      end
 
      subroutine zzs_3vert19(p,q,pq,i,form)
c     3 neutralinos loop
      implicit double precision (a-h,o-z)
      complex*16 c0,c11,c12,c21,c22,c23,c24
      complex*16 form(6)
      complex*16 zn
      complex*16 vl_nnz,vr_nnz,v_nns
      complex*16 a,b,c,x,y,z
      common/neut/fnm(4),zn(4,4)
      common/vpar/st,cw,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      do 10 k=1,4
        do 10 l=1,4
          do 10 m=1,4
            a = vr_nnz(l,k) + vl_nnz(l,k)
            x = vr_nnz(l,k) - vl_nnz(l,k)
            b = vr_nnz(k,m) + vl_nnz(k,m)
            y = vr_nnz(k,m) - vl_nnz(k,m)
            c = conjg(v_nns(m,l,i)) + v_nns(l,m,i)
            z = conjg(v_nns(m,l,i)) - v_nns(l,m,i)
            form(1) = form(1) + 2*(e/sct/2)**3
     1              *(fnm(k)*fnm(l)*fnm(m)*dble(a*b*c - x*y*c
     2              - x*b*z + a*y*z)*c0(fnm(k),fnm(m),fnm(l))
     3              + fnm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     4              *((p + pq)*c0(fnm(k),fnm(m),fnm(l)) + 0.5d0
     5              + (2*p + pq)*c11(fnm(k),fnm(m),fnm(l))
     6              + (q + 2*pq)*c12(fnm(k),fnm(m),fnm(l))
     7              + p*c21(fnm(k),fnm(m),fnm(l))
     8              + q*c22(fnm(k),fnm(m),fnm(l))
     9              + 2*pq*c23(fnm(k),fnm(m),fnm(l))
     a              + 4*c24(fnm(k),fnm(m),fnm(l)))
     b              - fnm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     c              *(p*c11(fnm(k),fnm(m),fnm(l)) + 0.5d0
     d              + pq*c12(fnm(k),fnm(m),fnm(l))
     e              + p*c21(fnm(k),fnm(m),fnm(l))
     f              + q*c22(fnm(k),fnm(m),fnm(l))
     g              + 2*pq*c23(fnm(k),fnm(m),fnm(l))
     h              + 2*c24(fnm(k),fnm(m),fnm(l))))
            form(1) = form(1) - 2*(e/sct/2)**3
     1              *fnm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     2              *((p + pq)*c11(fnm(k),fnm(m),fnm(l)) + 0.5d0
     3              + (q + pq)*c12(fnm(k),fnm(m),fnm(l))
     4              + p*c21(fnm(k),fnm(m),fnm(l))
     5              + q*c22(fnm(k),fnm(m),fnm(l))
     6              + 2*pq*c23(fnm(k),fnm(m),fnm(l))
     7              + 2*c24(fnm(k),fnm(m),fnm(l)))
            form(2) = form(2) + (e/sct)**3/2
     1              *(fnm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     2              + fnm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z))
     3              *(c11(fnm(k),fnm(m),fnm(l)) 
     4              + c21(fnm(k),fnm(m),fnm(l)))
            form(3) = form(3) + (e/sct)**3/2
     1              *(fnm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     2              *c22(fnm(k),fnm(m),fnm(l))
     3              + fnm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     4              *(c12(fnm(k),fnm(m),fnm(l))
     5              + c22(fnm(k),fnm(m),fnm(l))))
            form(4) = form(4) + 2*(e/sct/2)**3
     1              *(- fnm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2              *(c0(fnm(k),fnm(m),fnm(l)) 
     3              + c11(fnm(k),fnm(m),fnm(l)))
     4              + fnm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     5              *(c12(fnm(k),fnm(m),fnm(l))
     6              + 2*c23(fnm(k),fnm(m),fnm(l)))
     7              + fnm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8              *(c11(fnm(k),fnm(m),fnm(l)) 
     9              + c12(fnm(k),fnm(m),fnm(l))
     a              + 2*c23(fnm(k),fnm(m),fnm(l))))
            form(5) = form(5) + 2*(e/sct/2)**3
     1              *(fnm(k)*dble(a*b*c - x*y*c + x*b*z - a*y*z)
     2              *(c0(fnm(k),fnm(m),fnm(l))
     3              + c11(fnm(k),fnm(m),fnm(l)))
     4              + fnm(l)*dble(a*b*c + x*y*c - x*b*z - a*y*z)
     5              *(c12(fnm(k),fnm(m),fnm(l))
     6              + 2*c23(fnm(k),fnm(m),fnm(l)))
     7              + fnm(m)*dble(a*b*c + x*y*c + x*b*z + a*y*z)
     8              *(c11(fnm(k),fnm(m),fnm(l)) 
     9              + c12(fnm(k),fnm(m),fnm(l))
     a              + 2*c23(fnm(k),fnm(m),fnm(l))))
            form(6) = form(6) + 2*(e/sct/2)**3
     1              *(fnm(k)*dimag(x*y*z - x*b*c + a*y*c - a*b*z)
     2              *(c0(fnm(k),fnm(m),fnm(l)) 
     3              + c11(fnm(k),fnm(m),fnm(l)))
     4              + fnm(l)*dimag(x*y*z - x*b*c - a*y*c + a*b*z)
     5              *c12(fnm(k),fnm(m),fnm(l))
     6              + fnm(m)*dimag(x*y*z + x*b*c + a*y*c + a*b*z)
     7              *(c11(fnm(k),fnm(m),fnm(l))
     8              - c12(fnm(k),fnm(m),fnm(l))))
10          call creset
      return
      end
 
      subroutine zzs_4vert1(p,q,pq,i,form)
c     2 sfermions in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      complex*16 v_llzz,v_uuzz,v_ddzz
      complex*16 v_lls,v_uus,v_dds
      complex*16 zv,zl,zu,zd
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/slmass/vm(3),slm(6),zv(3,3),zl(6,6)
      common/sqmass/sum(6),sdm(6),zu(6,6),zd(6,6)
      do 10 k=1,3
10      form(1) = form(1) + (e/sct)**4*br(i)/8*b0(q,vm(k),vm(k))
      do 20 k=1,6
        do 20 l=1,6
          form(1) = form(1) - 2*e2*v_llzz(l,k)*v_lls(k,l,i)
     1            *b0(q,slm(l),slm(k))
          form(1) = form(1) - 6*e2*v_uuzz(l,k)*v_uus(k,l,i)
     1            *b0(q,sum(l),sum(k))
20        form(1) = form(1) - 6*e2*v_ddzz(l,k)*v_dds(k,l,i)
     1            *b0(q,sdm(l),sdm(k))
      return
      end
 
      subroutine zzs_4vert3(p,q,pq,i,form)
c     2 charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
10      form(1) = form(1) + e*e2*(ct2 - st2)**2/sct2/st/4
     1          *v_hhs(i,j,j)*b0(q,cm(j),cm(j))
      return
      end
 
      subroutine zzs_4vert4(p,q,pq,i,form)
c     2 scalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
10      form(1) = form(1) + (e/sct/2)**4*v_sss(i,j,j)*b0(q,rm(j),rm(j))
      return
      end
 
      subroutine zzs_4vert5(p,q,pq,i,form)
c     2 pseudoscalars in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      do 10 j=1,2
10      form(1) = form(1) + (e/sct/2)**4*ah(j,j)*br(i)*b0(q,pm(j),pm(j))
      return
      end
 
      subroutine zzs_4vert6(p,q,pq,i,form)
c     W pair in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) + (e/st)**4*ct2*cr(i)*(3*b0(q,wm,wm) - 2)
      return
      end
 
      subroutine zzs_4vert79(p,q,pq,i,form)
c     Z0 + scalar in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      form(1) = form(1) + (e/sct)**4/4*cr(i)*(b0(p,zm,rm(i))
     1        + b0(p + 2*pq + q,zm,rm(i)))
      return
      end
 
      subroutine zzs_4vert810(p,q,pq,i,form)
c     W + charged Higgs in loop
      implicit double precision (a-h,o-z)
      complex*16 b0
      complex*16 form(6)
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      form(1) = form(1) - e*e2*zm*st/ct*am(i,2)*(b0(p,wm,wm)
     1        + b0(p + 2*pq + q,wm,wm))
      return
      end
 
      subroutine zzs_vert(p,q,pq,i,form)
c     Full bare ZZS formfactor 
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/parcont/if,is,ig,ic,in,iq,il
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/cargs/p1,q1,pq1
      do 10 j=1,6
10      form(j) = (0,0)   
      if (.not.vstat) return
      p1  = p
      q1  = q
      pq1 = pq
      if (if.eq.1) call zzs_3vert1(p,q,pq,i,form)
      if (is.eq.1) then
        call zzs_3vert2(p,q,pq,i,form)
        call zzs_4vert1(p,q,pq,i,form)
      end if
      if (ig.eq.1) then
        call zzs_3vert3(p,q,pq,i,form)
        call zzs_3vert4(p,q,pq,i,form)
        call zzs_3vert5(p,q,pq,i,form)
        call zzs_3vert6(p,q,pq,i,form)
        call zzs_3vert79(p,q,pq,i,form)
        call zzs_3vert8(p,q,pq,i,form)
        call zzs_3vert10(p,q,pq,i,form)
        call zzs_3vert11(p,q,pq,i,form)
        call zzs_3vert12(p,q,pq,i,form)
        call zzs_3vert13(p,q,pq,i,form)
        call zzs_3vert14(p,q,pq,i,form)
        call zzs_3vert15(p,q,pq,i,form)
        call zzs_3vert16(p,q,pq,i,form)
        call zzs_3vert17(p,q,pq,i,form)
        call zzs_4vert3(p,q,pq,i,form)
        call zzs_4vert4(p,q,pq,i,form)
        call zzs_4vert5(p,q,pq,i,form)
        call zzs_4vert6(p,q,pq,i,form)
        call zzs_4vert79(p,q,pq,i,form)
        call zzs_4vert810(p,q,pq,i,form)
      end if
      if (ic.eq.1) call zzs_3vert18(p,q,pq,i,form)
      if (in.eq.1) call zzs_3vert19(p,q,pq,i,form)
      do 20 j=1,5
 20     form(j) = - form(j)/16/pi/pi
      form(6) = form(6)/16/pi/pi
      return
      end
 
      subroutine zzs_ren(p,q,pq,i,form)
c     Full renormalized ZZS formfactor
      implicit double precision (a-h,o-z)
      complex*16 form(6)
      logical vstat,fstat
      common/vswitch/vstat,fstat
      common/vpar/st,ct,st2,ct2,sct,sct2,e,e2,alpha,wm,wm2,zm,zm2,pi,sq2
      common/grconst/dza,dzb,dz2,dx
      common/hrconst/dzh1,dzh2,tt1,tt2,dhs,dv1,dv2
      common/hmass/cm(2),rm(2),pm(2),zr(2,2),zh(2,2)
      common/vev/v1,v2
      do 10 j=1,6
 10     form(j) = (0,0)
      if (.not.vstat) return
      call zzs_vert(p,q,pq,i,form)
      form(1) =  form(1) + e2/st2*(dz2 - dza - dv1/v1/2/ct2)*cr(i)
     1         + e2/2/sct2*(v1*dzh1*zr(1,i) + v2*dzh2*zr(2,i))
      return
      end

 
 





 

