#include <iostream>
#include <cmath>
using namespace std;

struct Punkt {
    double x, y;
    Punkt(double x = 0, double y = 0) : x(x), y(y) { }
    operator double() {
        return sqrt(x*x+y*y);
    }
};

struct Segment {
    Punkt A, B;
    Segment(Punkt A = Punkt(), Punkt B = Punkt())
        : A(A), B(B)
    { }
    operator Punkt() {
        return Punkt( (A.x+B.x)/2, (A.y+B.y)/2 );
    }
};

void showPoint(Punkt A) {
    cout << "Point[" << A.x << "," << A.y << "]";
}

void showSegment(Segment AB) {
    cout << "Segment: ";
    showPoint(AB.A);
    cout << "--";
    showPoint(AB.B);
    cout << endl;
}

void showDouble(double d) {
    cout << "Double " << d;
}

int main() {
    Punkt A(3,4);
    showPoint(A);    // 1
    cout << endl;
    showDouble(A);   // 2

    cout << endl;

    Segment BC(Punkt(1,1),Punkt(3,3));
    showSegment(BC); // 3
    showPoint(BC);   // 4

    cout << endl;
}
