#define F_CPU 1000000UL
#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sfr_defs.h>

uint8_t u[4]={128,128,128,128};
uint16_t  n1,m1,n2,m2;
uint8_t s1,s2;


ISR(ADC_vect)
{// czytanie ADC
	char k;
	PORTD|=0x4;
	u[k=(ADMUX&0x3)]=ADCH;
	if(k<2)
	{
		n1=20*u[1]+5000;
		m1=((long)n1*u[0])>>11;
		n1-=m1;
	}
	else
	{
		n2=10*u[3]+3300;
		m2=((long)n1*u[2])>>11;
		n2-=m2;
	}
	PORTD&=~0x4;
};


ISR(TIM0_OVF_vect)
{// czytanie ADC
	PORTD|=0x8;
	ADMUX|=0x3&((ADMUX&0x3)+1);
	ADCSRA|=0x40;
	PORTD|=0x8;
}

void upd_out()
{// output sumy
	char out;
	out=(s1|s2)&3;
	if(out==3) out=0;
	PORTD = (PORTD & ~0x3) | out;
}

ISR(TIM1_OVF_vect)
{
	switch(s1)
	{
	  case 1:
			TCNT1-=n1;
			s1=0x10;
			break;
	  case 2:
	  		TCNT1-=n1;
			s1=0x20;
			break;
	  case 0x10:
	  		TCNT1-=m1;
			s1=0x1;
			break;
	  case 0x20:
	  		TCNT1-=m1;
			s1=0x2;
			break;
	}
	upd_out();
}

uint8_t TCNT2H,TCNT2L;

inline void TCNT2SET(int T)
{
	TCNT2H=(T>>8);
	TCNT2L=T&0xFF;
	if(!TCNT2H)	TCNT2-=TCNT2L;
}

ISR(TIM2_OVF_vect)
{
	if(!TCNT2H)
	{
		TCNT2H--;
		if(!TCNT2H) TCNT2-=TCNT2L;
		return;
	}
	switch(s1)
	{
	  case 1:
			TCNT2SET(n2);
			s2=0x10;
			break;
	  case 2:
	  		TCNT2SET(n2);
			s2=0x20;
			break;
	  case 0x10:
	  		TCNT2SET(m2);
			s2=0x1;
			break;
	  case 0x20:
	  		TCNT2SET(m2);
			s2=0x2;
			break;
	}
	upd_out();
}

void main()
{
TCCR0B=0x03; // clk/64
TIMSK0=0x01; // ovf_int_en
TCCR1B=0x01; // clk/1
TIMSK1=_BV (TOIE1); // ovf_int_en
TCCR2B=0x01; // clk/1
TIMSK2=0x01; // ovf_int_en
TCNT1=-10000;
TCNT2H=-40;

PORTD=0;
DDRD=0xFF;
ADMUX=0x60; // REF=AVCC, ADLAR
ADCSRA=0x8B;  // ADEN, CLK/8=125k
DIDR0=0x0F;
sei();
while(1);
}
